// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _V3d_PositionalLight_HeaderFile
#define _V3d_PositionalLight_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_V3d_PositionalLight_HeaderFile
#include <Handle_V3d_PositionalLight.hxx>
#endif

#ifndef _V3d_PositionLight_HeaderFile
#include <V3d_PositionLight.hxx>
#endif
#ifndef _Handle_V3d_Viewer_HeaderFile
#include <Handle_V3d_Viewer.hxx>
#endif
#ifndef _V3d_Coordinate_HeaderFile
#include <V3d_Coordinate.hxx>
#endif
#ifndef _Quantity_NameOfColor_HeaderFile
#include <Quantity_NameOfColor.hxx>
#endif
#ifndef _Quantity_Coefficient_HeaderFile
#include <Quantity_Coefficient.hxx>
#endif
#ifndef _Handle_V3d_View_HeaderFile
#include <Handle_V3d_View.hxx>
#endif
#ifndef _V3d_TypeOfRepresentation_HeaderFile
#include <V3d_TypeOfRepresentation.hxx>
#endif
#ifndef _Handle_Graphic3d_Group_HeaderFile
#include <Handle_Graphic3d_Group.hxx>
#endif
class Viewer_BadValue;
class V3d_Viewer;
class V3d_View;
class Graphic3d_Group;


//! Creation and modification of an isolated <br>
//!          light source. <br>
class V3d_PositionalLight : public V3d_PositionLight {

public:
 // Methods PUBLIC
 // 

//! Creates an isolated light source X,Y,Z in the viewer. <br>
//!          It is also defined by the color Color and <br>
//!          two attenuation factors Attenuation1, Attenuation2. <br>
//!	    The resulting attenuation factor determining the <br>
//!	    illumination of a surface depends on the following <br>
//!	    formula : <br>
//!	    F = 1/(A1 + A2*Length) <br>
//!		A1,A2 being the two factors of attenuation <br>
//!	 	Length is the distance of the isolated source <br>
//!	    from the surface. <br>//!  Warning!  raises BadValue from Viewer <br>
//!          if one of the attenuation coefficients is not between 0 et 1. <br>
Standard_EXPORT V3d_PositionalLight(const Handle(V3d_Viewer)& VM,const V3d_Coordinate X,const V3d_Coordinate Y,const V3d_Coordinate Z,const Quantity_NameOfColor Color = Quantity_NOC_WHITE,const Quantity_Coefficient Attenuation1 = 1.0,const Quantity_Coefficient Attenuation2 = 0.0);

//! Creates a light source of the Positional type <br>
//!          in the viewer. <br>
//!          Xt,Yt,Zt : Coordinate of Target light source. <br>
//!          Xp,Yp,Zp : Coordinate of Position light source. <br>
//!          The light source is also defined by the color Color <br>
//!          and two attenuation factors Attenuation1, <br>
//!          Attenuation2 that determine the illumination of a <br>
//!          surface using the following formula : <br>
//!          F = 1/(A1 + A2*Length) where: <br>
//!          -   A1,A2 are the two attenuation factors, and <br>
//!          -   Length is the distance from the isolated source. <br>//!  Warning! raises BadValue from Viewer <br>
//!          if one of the attenuation coefficients is not between 0 et 1. <br>
Standard_EXPORT V3d_PositionalLight(const Handle(V3d_Viewer)& VM,const V3d_Coordinate Xt,const V3d_Coordinate Yt,const V3d_Coordinate Zt,const V3d_Coordinate Xp,const V3d_Coordinate Yp,const V3d_Coordinate Zp,const Quantity_NameOfColor Color = Quantity_NOC_WHITE,const Quantity_Coefficient Attenuation1 = 1.0,const Quantity_Coefficient Attenuation2 = 0.0);

//! Defines the position of the light source. <br>
Standard_EXPORT virtual  void SetPosition(const V3d_Coordinate X,const V3d_Coordinate Y,const V3d_Coordinate Z) ;

//! Defines the attenuation factors. <br>
//!  Warning: raises BadValue from Viewer <br>
//!          if one of the attenuation coefficients is not between 0 et 1. <br>
Standard_EXPORT   void SetAttenuation(const Quantity_Coefficient A1,const Quantity_Coefficient A2) ;

//! Display the graphic structure of light source <br>
//!          in the choosen view. We have three type of representation <br>
//!          - SIMPLE   : Only the light source is displayed. <br>
//!          - PARTIAL  : The light source and the light space are <br>
//!                       displayed. <br>
//!          - COMPLETE : The light source, the light space and the <br>
//!                       radius of light space are displayed. <br>
//!          We can choose the "SAMELAST" as parameter of representation <br>
//!          In this case the graphic structure representation will be <br>
//!          the last displayed. <br>
Standard_EXPORT   void Display(const Handle(V3d_View)& aView,const V3d_TypeOfRepresentation Representation) ;

//! Returns the position of the light source. <br>
Standard_EXPORT   void Position(V3d_Coordinate& X,V3d_Coordinate& Y,V3d_Coordinate& Z) const;

//! Returns the attenuation factors A1,A2 of the light <br>
//! source used at construction time. <br>
Standard_EXPORT   void Attenuation(Quantity_Coefficient& A1,Quantity_Coefficient& A2) const;
//Standard_EXPORT ~V3d_PositionalLight();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Defined the representation of the positional light source. <br>
Standard_EXPORT   void Symbol(const Handle(Graphic3d_Group)& gsymbol,const Handle(V3d_View)& aView) const;


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
