// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Units_Token_HeaderFile
#define _Units_Token_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Units_Token_HeaderFile
#include <Handle_Units_Token.hxx>
#endif

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Units_Dimensions_HeaderFile
#include <Handle_Units_Dimensions.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Units_Dimensions;


//! This class defines an elementary word contained in <br>
//!          a Sentence object. <br>
class Units_Token : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates and returns a empty token. <br>
Standard_EXPORT Units_Token();

//! Creates  and returns  a token.   <aword>  is  a string <br>
//!          containing the available word. <br>
Standard_EXPORT Units_Token(const Standard_CString aword);

//! Creates and returns a  token.  <atoken> is  copied  in <br>
//!          the returned token. <br>
Standard_EXPORT Units_Token(const Handle(Units_Token)& atoken);

//! Creates  and  returns a  token.   <aword> is  a string <br>
//!          containing the  available word and  <amean>  gives the <br>
//!          signification of the token. <br>
Standard_EXPORT Units_Token(const Standard_CString aword,const Standard_CString amean);

//! Creates   and  returns a  token.   <aword> is a string <br>
//!          containing   the available  word,  <amean> gives   the <br>
//!          signification of the token and <avalue> is the numeric <br>
//!          value of the dimension. <br>
Standard_EXPORT Units_Token(const Standard_CString aword,const Standard_CString amean,const Standard_Real avalue);

//! Creates and returns  a  token.  <aword> is   a  string <br>
//!          containing the   available   word, <amean>   gives the <br>
//!          signification of  the  token, <avalue> is  the numeric <br>
//!          value  of the dimension,  and <adimensions>   is   the <br>
//!          dimension of the given word <aword>. <br>
Standard_EXPORT Units_Token(const Standard_CString aword,const Standard_CString amean,const Standard_Real avalue,const Handle(Units_Dimensions)& adimension);

//! Creates and returns a  token, which is a ShiftedToken. <br>
Standard_EXPORT virtual  Handle_Units_Token Creates() const;

//! Returns the length of the word. <br>
Standard_EXPORT   Standard_Integer Length() const;
//! Returns the string <theword> <br>
  TCollection_AsciiString Word() const;
//! Sets the field <theword> to <aword>. <br>
  void Word(const Standard_CString aword) ;
//! Returns the significance of the word  <theword>, which <br>
//!          is in the field <themean>. <br>
  TCollection_AsciiString Mean() const;
//! Sets the field <themean> to <amean>. <br>
  void Mean(const Standard_CString amean) ;
//! Returns the value stored in the field <thevalue>. <br>
  Standard_Real Value() const;
//! Sets the field <thevalue> to <avalue>. <br>
  void Value(const Standard_Real avalue) ;
//! Returns the dimensions of the token <thedimensions>. <br>
  Handle_Units_Dimensions Dimensions() const;

//! Sets the field <thedimensions> to <adimensions>. <br>
Standard_EXPORT   void Dimensions(const Handle(Units_Dimensions)& adimensions) ;

//! Updates     the  token  <me>    with  the   additional <br>
//!          signification  <amean> by  concatenation   of the  two <br>
//!          strings   <themean>    and   <amean>.   If    the  two <br>
//!          significations are  the same  , an information message <br>
//!          is written in the output device. <br>
//! <br>
Standard_EXPORT   void Update(const Standard_CString amean) ;


Standard_EXPORT   Handle_Units_Token Add(const Standard_Integer aninteger) const;
friend Standard_EXPORT Handle(Units_Token) operator +(const Handle(Units_Token)&,const Standard_Integer);

//! Returns a  token which is  the addition  of  <me>  and <br>
//!          another token <atoken>. The  addition  is  possible if <br>
//!          and only if the dimensions are the same. <br>
Standard_EXPORT   Handle_Units_Token Add(const Handle(Units_Token)& atoken) const;
friend Standard_EXPORT Handle(Units_Token) operator +(const Handle(Units_Token)&,const Handle(Units_Token)&);

//! Returns a token  which is the  subtraction of <me> and <br>
//!          another token <atoken>. The subtraction is possible if <br>
//!          and only if the dimensions are the same. <br>
Standard_EXPORT   Handle_Units_Token Subtract(const Handle(Units_Token)& atoken) const;
friend Standard_EXPORT Handle(Units_Token) operator -(const Handle(Units_Token)&,const Handle(Units_Token)&);

//! Returns a  token  which  is the  product of   <me> and <br>
//!          another token <atoken>. <br>
Standard_EXPORT   Handle_Units_Token Multiply(const Handle(Units_Token)& atoken) const;
friend Standard_EXPORT Handle(Units_Token) operator *(const Handle(Units_Token)&,const Handle(Units_Token)&);

//! This   virtual method is   called  by  the Measurement <br>
//!          methods,  to  compute    the   measurement   during  a <br>
//!          conversion. <br>
Standard_EXPORT virtual  Standard_Real Multiplied(const Standard_Real avalue) const;

//! Returns a token which is the division of <me> by another <br>
//!          token <atoken>. <br>
Standard_EXPORT   Handle_Units_Token Divide(const Handle(Units_Token)& atoken) const;
friend Standard_EXPORT Handle(Units_Token) operator /(const Handle(Units_Token)&,const Handle(Units_Token)&);

//! This  virtual  method  is  called by  the  Measurement <br>
//!          methods,   to   compute   the measurement  during    a <br>
//!          conversion. <br>
Standard_EXPORT virtual  Standard_Real Divided(const Standard_Real avalue) const;

//! Returns a token which is <me> to the power  of another <br>
//!          token <atoken>.  The computation  is possible  only if <br>
//!          <atoken> is a dimensionless constant. <br>
Standard_EXPORT   Handle_Units_Token Power(const Handle(Units_Token)& atoken) const;
friend Standard_EXPORT Handle(Units_Token) pow(const Handle(Units_Token)&,const Handle(Units_Token)&);

//! Returns a token which is <me> to the power  of <anexponent>. <br>
Standard_EXPORT   Handle_Units_Token Power(const Standard_Real anexponent) const;
friend Standard_EXPORT Handle(Units_Token) pow(const Handle(Units_Token)&,const Standard_Real);

//! Returns true if  the  field <theword> and  the  string <br>
//!          <astring> are the same, false otherwise. <br>
Standard_EXPORT   Standard_Boolean IsEqual(const Standard_CString astring) const;
friend Standard_EXPORT Standard_Boolean operator ==(const Handle(Units_Token)&,const Standard_CString);

//! Returns true  if the  field  <theword> and  the string <br>
//!          <theword> contained  in  the  token <atoken>  are  the <br>
//!          same, false otherwise. <br>
Standard_EXPORT   Standard_Boolean IsEqual(const Handle(Units_Token)& atoken) const;
//! Returns false if  the field <theword>  and the  string <br>
//!          <astring> are the same, true otherwise. <br>
  Standard_Boolean IsNotEqual(const Standard_CString astring) const;
friend Standard_EXPORT Standard_Boolean operator !=(const Handle(Units_Token)&,const Standard_CString);
//! Returns false if  the field <theword>  and the  string <br>
//!          <theword> contained  in the  token  <atoken>  are  the <br>
//!          same, true otherwise. <br>
  Standard_Boolean IsNotEqual(const Handle(Units_Token)& atoken) const;
//! Returns   true  if the   field <theword>  is  strictly <br>
//!          contained at  the beginning  of the string  <astring>, <br>
//!          false otherwise. <br>
  Standard_Boolean IsLessOrEqual(const Standard_CString astring) const;
friend Standard_EXPORT Standard_Boolean operator <=(const Handle(Units_Token)&,const Standard_CString);
//! Returns false  if   the field   <theword> is  strictly <br>
//!          contained at  the  beginning  of the string <astring>, <br>
//!          true otherwise. <br>
  Standard_Boolean IsGreater(const Standard_CString astring) const;
friend Standard_EXPORT Standard_Boolean operator >(const Handle(Units_Token)&,const Standard_CString);
//! Returns false  if   the field   <theword> is  strictly <br>
//!          contained at  the  beginning  of the string <astring>, <br>
//!          true otherwise. <br>
  Standard_Boolean IsGreater(const Handle(Units_Token)& atoken) const;
friend Standard_EXPORT Standard_Boolean operator >(const Handle(Units_Token)&,const Handle(Units_Token)&);
//! Returns true  if  the string <astring>   is   strictly <br>
//!          contained   at the  beginning  of  the field <theword> <br>
//!          false otherwise. <br>
  Standard_Boolean IsGreaterOrEqual(const Handle(Units_Token)& atoken) const;
friend Standard_EXPORT Standard_Boolean operator >=(const Handle(Units_Token)&,const Handle(Units_Token)&);

//! Destroies the Token <br>
Standard_EXPORT virtual  void Destroy() ;
~Units_Token()
{
  Destroy();
}


//! Useful for debugging <br>
Standard_EXPORT virtual  void Dump(const Standard_Integer ashift,const Standard_Integer alevel) const;




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TCollection_AsciiString theword;
TCollection_AsciiString themean;
Standard_Real thevalue;
Handle_Units_Dimensions thedimensions;


};


#include <Units_Token.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
