// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopOpeBRepBuild_ShellFaceSet_HeaderFile
#define _TopOpeBRepBuild_ShellFaceSet_HeaderFile

#ifndef _TopoDS_Solid_HeaderFile
#include <TopoDS_Solid.hxx>
#endif
#ifndef _TopOpeBRepBuild_ShapeSet_HeaderFile
#include <TopOpeBRepBuild_ShapeSet.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
class TopoDS_Shape;
class TopoDS_Solid;
class TCollection_AsciiString;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! a bound is a shell, a boundelement is a face. <br>
//! The ShapeSet stores : <br>
//! - a list of shell (bounds), <br>
//! - a list of face (boundelements) to start reconstructions, <br>
//! - a map of edge giving the list of face incident to an edge. <br>
class TopOpeBRepBuild_ShellFaceSet  : public TopOpeBRepBuild_ShapeSet {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a ShellFaceSet to build blocks of faces <br>
//! connected by edges. <br>
Standard_EXPORT TopOpeBRepBuild_ShellFaceSet();

//! Creates a ShellFaceSet to build blocks of faces <br>
//! connected by edges. <br>
Standard_EXPORT TopOpeBRepBuild_ShellFaceSet(const TopoDS_Shape& S,const Standard_Address Addr = NULL);


Standard_EXPORT  const TopoDS_Solid& Solid() const;


Standard_EXPORT virtual  void AddShape(const TopoDS_Shape& S) ;


Standard_EXPORT virtual  void AddStartElement(const TopoDS_Shape& S) ;


Standard_EXPORT virtual  void AddElement(const TopoDS_Shape& S) ;


Standard_EXPORT virtual  void DumpSS() ;


Standard_EXPORT virtual  TCollection_AsciiString SName(const TopoDS_Shape& S,const TCollection_AsciiString& sb = "",const TCollection_AsciiString& sa = "") const;


Standard_EXPORT virtual  TCollection_AsciiString SName(const TopTools_ListOfShape& S,const TCollection_AsciiString& sb = "",const TCollection_AsciiString& sa = "") const;


Standard_EXPORT virtual  TCollection_AsciiString SNameori(const TopoDS_Shape& S,const TCollection_AsciiString& sb = "",const TCollection_AsciiString& sa = "") const;


Standard_EXPORT virtual  TCollection_AsciiString SNameori(const TopTools_ListOfShape& S,const TCollection_AsciiString& sb = "",const TCollection_AsciiString& sa = "") const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Solid mySolid;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
