// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TNaming_Builder_HeaderFile
#define _TNaming_Builder_HeaderFile

#ifndef _TNaming_PtrDataMapOfShapePtrRefShape_HeaderFile
#include <TNaming_PtrDataMapOfShapePtrRefShape.hxx>
#endif
#ifndef _TNaming_PtrAttribute_HeaderFile
#include <TNaming_PtrAttribute.hxx>
#endif
#ifndef _Handle_TNaming_NamedShape_HeaderFile
#include <Handle_TNaming_NamedShape.hxx>
#endif
class Standard_ConstructionError;
class TDF_Label;
class TopoDS_Shape;
class TNaming_NamedShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A tool to create and maintain topological <br>
//! attributes. <br>
//! Constructor creates an empty <br>
//! TNaming_NamedShape attribute at the given <br>
//! label. It allows adding "old shape" and "new <br>
//! shape" pairs with the specified evolution to this <br>
//! named shape. One evolution type per one <br>
//! builder must be used. <br>
class TNaming_Builder  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//!  Create an   Builder. <br>
//!  Warning:  Before Addition copies the current Value, and clear <br>
Standard_EXPORT TNaming_Builder(const TDF_Label& aLabel);

//!  Records the shape newShape which was <br>
//! generated during a topological construction. <br>
//!  As an example, consider the case of a face <br>
//!  generated in construction of a box. <br>
Standard_EXPORT   void Generated(const TopoDS_Shape& newShape) ;

//! Records the shape newShape which was <br>
//!  generated from the shape oldShape during a topological construction. <br>
//! As an example, consider the case of a face <br>
//! generated from an edge in construction of a prism. <br>
Standard_EXPORT   void Generated(const TopoDS_Shape& oldShape,const TopoDS_Shape& newShape) ;

//!  Records the shape oldShape which was deleted from the current label. <br>
//! As an example, consider the case of a face removed by a Boolean operation. <br>
Standard_EXPORT   void Delete(const TopoDS_Shape& oldShape) ;

//!  Records the shape newShape which is a <br>
//! modification of the shape oldShape. <br>
//! As an example, consider the case of a face split <br>
//!  or merged in a Boolean operation. <br>
//! <br>
Standard_EXPORT   void Modify(const TopoDS_Shape& oldShape,const TopoDS_Shape& newShape) ;

//! Records the shape newShape which is a <br>
//! modification of the shape oldShape but has a <br>
//! different geometry as a result of the construction operation. <br>
//! As an example, consider the case of a face <br>
//! resulting from construction of a draft in a box or prism. <br>
Standard_EXPORT   void Replace(const TopoDS_Shape& oldShape,const TopoDS_Shape& newShape) ;

//!   Add a  Shape to the current label ,  This Shape is <br>
//!          unmodified.  Used for example  to define a set <br>
//!          of shapes under a label. <br>
Standard_EXPORT   void Select(const TopoDS_Shape& aShape,const TopoDS_Shape& inShape) ;

//! Returns the NamedShape which has been build or is under construction. <br>
Standard_EXPORT   Handle_TNaming_NamedShape NamedShape() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TNaming_PtrDataMapOfShapePtrRefShape myMap;
TNaming_PtrAttribute myAtt;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
