// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TDF_Delta_HeaderFile
#define _TDF_Delta_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TDF_Delta_HeaderFile
#include <Handle_TDF_Delta.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TDF_AttributeDeltaList_HeaderFile
#include <TDF_AttributeDeltaList.hxx>
#endif
#ifndef _TCollection_ExtendedString_HeaderFile
#include <TCollection_ExtendedString.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_TDF_AttributeDelta_HeaderFile
#include <Handle_TDF_AttributeDelta.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Standard_OutOfRange;
class TDF_Data;
class TDF_AttributeDelta;
class TDF_LabelList;
class TDF_AttributeDeltaList;
class TCollection_ExtendedString;


//! A delta set is available at <aSourceTime>. If <br>
//!          applied, it restores the TDF_Data in the state it <br>
//!          was at <aTargetTime>. <br>
class TDF_Delta : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates a delta. <br>
Standard_EXPORT TDF_Delta();
//! Returns true if there is nothing to undo. <br>
//! <br>
  Standard_Boolean IsEmpty() const;
//! Returns true if the Undo action of <me> is <br>
//!          applicable at <aCurrentTime>. <br>
//! <br>
  Standard_Boolean IsApplicable(const Standard_Integer aCurrentTime) const;
//! Returns the field <myBeginTime>. <br>
  Standard_Integer BeginTime() const;
//! Returns the field <myEndTime>. <br>
  Standard_Integer EndTime() const;

//! Adds in <aLabelList> the labels of the attribute deltas. <br>
//!          Caution: <aLabelList> is not cleared before use. <br>
Standard_EXPORT   void Labels(TDF_LabelList& aLabelList) const;
//! Returns the field <myAttDeltaList>. <br>
 const TDF_AttributeDeltaList& AttributeDeltas() const;
//! Returns a name associated with this delta. <br>
  TCollection_ExtendedString Name() const;
//! Associates a name <theName> with this delta <br>
  void SetName(const TCollection_ExtendedString& theName) ;


Standard_EXPORT   void Dump(Standard_OStream& OS) const;
//Standard_EXPORT ~TDF_Delta();


friend class TDF_Data;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Validates <me> at <aBeginTime>. If applied, it <br>
//!          restores the TDF_Data in the state it was at <br>
//!          <anEndTime>. Reserved to TDF_Data. <br>
Standard_EXPORT   void Validity(const Standard_Integer aBeginTime,const Standard_Integer anEndTime) ;

//! Adds an AttributeDelta to the list. Reserved to <br>
//!          TDF_Data. <br>
Standard_EXPORT   void AddAttributeDelta(const Handle(TDF_AttributeDelta)& anAttributeDelta) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void BeforeOrAfterApply(const Standard_Boolean before) const;


Standard_EXPORT   void Apply() ;


 // Fields PRIVATE
 //
Standard_Integer myBeginTime;
Standard_Integer myEndTime;
TDF_AttributeDeltaList myAttDeltaList;
TCollection_ExtendedString myName;


};


#include <TDF_Delta.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
