// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _StepData_FieldListD_HeaderFile
#define _StepData_FieldListD_HeaderFile

#ifndef _Handle_StepData_HArray1OfField_HeaderFile
#include <Handle_StepData_HArray1OfField.hxx>
#endif
#ifndef _StepData_FieldList_HeaderFile
#include <StepData_FieldList.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class StepData_HArray1OfField;
class Standard_OutOfRange;
class StepData_Field;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes a list of fields, in a general way <br>
//!           This basic class is for a null size list <br>
//!           Subclasses are for 1, N (fixed) or Dynamic sizes <br>
class StepData_FieldListD  : public StepData_FieldList {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a FieldListD of <nb> Fields <br>
Standard_EXPORT StepData_FieldListD(const Standard_Integer nb);

//! Sets a new count of Fields. Former contents are lost <br>
Standard_EXPORT   void SetNb(const Standard_Integer nb) ;

//! Returns the count of fields. Here, returns starting <nb> <br>
Standard_EXPORT virtual  Standard_Integer NbFields() const;

//! Returns the field n0 <num> between 1 and NbFields (read only) <br>
Standard_EXPORT virtual const StepData_Field& Field(const Standard_Integer num) const;

//! Returns the field n0 <num> between 1 and NbFields, in order to <br>
//!           modify its content <br>
Standard_EXPORT virtual  StepData_Field& CField(const Standard_Integer num) ;


Standard_EXPORT virtual  void Destroy() ;
Standard_EXPORT virtual ~StepData_FieldListD() { Destroy(); }





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_StepData_HArray1OfField thefields;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
