// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _StepBasic_Unit_HeaderFile
#define _StepBasic_Unit_HeaderFile

#ifndef _StepData_SelectType_HeaderFile
#include <StepData_SelectType.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_StepBasic_NamedUnit_HeaderFile
#include <Handle_StepBasic_NamedUnit.hxx>
#endif
#ifndef _Handle_StepBasic_DerivedUnit_HeaderFile
#include <Handle_StepBasic_DerivedUnit.hxx>
#endif
class Standard_Transient;
class StepBasic_NamedUnit;
class StepBasic_DerivedUnit;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Implements a select type unit (NamedUnit or DerivedUnit) <br>
class StepBasic_Unit  : public StepData_SelectType {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates empty object <br>
Standard_EXPORT StepBasic_Unit();

//! Recognizes a type of Unit Entity <br>
//!        1 -> NamedUnit <br>
//!        2 -> DerivedUnit <br>
Standard_EXPORT   Standard_Integer CaseNum(const Handle(Standard_Transient)& ent) const;

//! returns Value as a NamedUnit (Null if another type) <br>
Standard_EXPORT   Handle_StepBasic_NamedUnit NamedUnit() const;

//! returns Value as a DerivedUnit (Null if another type) <br>
Standard_EXPORT   Handle_StepBasic_DerivedUnit DerivedUnit() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
