// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _StdPrs_PoleCurve_HeaderFile
#define _StdPrs_PoleCurve_HeaderFile

#ifndef _Prs3d_Root_HeaderFile
#include <Prs3d_Root.hxx>
#endif
#ifndef _Handle_Prs3d_Presentation_HeaderFile
#include <Handle_Prs3d_Presentation.hxx>
#endif
#ifndef _Handle_Prs3d_Drawer_HeaderFile
#include <Handle_Prs3d_Drawer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Prs3d_Presentation;
class Adaptor3d_Curve;
class Prs3d_Drawer;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A framework to provide display of Bezier or BSpline curves. <br>
class StdPrs_PoleCurve  : public Prs3d_Root {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Defines display of BSpline and Bezier curves. <br>
//! Adds the 3D curve aCurve to the <br>
//! StdPrs_PoleCurve algorithm. This shape is found in <br>
//! the presentation object aPresentation, and its display <br>
//! attributes are set in the attribute manager aDrawer. <br>
//! The curve object from Adaptor3d provides data from <br>
//! a Geom curve. This makes it possible to use the <br>
//! surface in a geometric algorithm. <br>
Standard_EXPORT static  void Add(const Handle(Prs3d_Presentation)& aPresentation,const Adaptor3d_Curve& aCurve,const Handle(Prs3d_Drawer)& aDrawer) ;

//! returns true if the distance between the point (X,Y,Z) and the <br>
//!          broken line made of the poles is less then aDistance. <br>
Standard_EXPORT static  Standard_Boolean Match(const Quantity_Length X,const Quantity_Length Y,const Quantity_Length Z,const Quantity_Length aDistance,const Adaptor3d_Curve& aCurve,const Handle(Prs3d_Drawer)& aDrawer) ;

//! returns the pole  the most near of the point (X,Y,Z) and <br>
//!          returns its range. The distance between the pole and <br>
//!          (X,Y,Z) must be less then aDistance. If no pole corresponds, 0 is returned. <br>
Standard_EXPORT static  Standard_Integer Pick(const Quantity_Length X,const Quantity_Length Y,const Quantity_Length Z,const Quantity_Length aDistance,const Adaptor3d_Curve& aCurve,const Handle(Prs3d_Drawer)& aDrawer) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
