// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeCustom_Curve2d_HeaderFile
#define _ShapeCustom_Curve2d_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom2d_Line_HeaderFile
#include <Handle_Geom2d_Line.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Handle_Geom2d_BSplineCurve_HeaderFile
#include <Handle_Geom2d_BSplineCurve.hxx>
#endif
class TColgp_Array1OfPnt2d;
class Geom2d_Line;
class Geom2d_Curve;
class Geom2d_BSplineCurve;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Converts curve2d to analytical form with given <br>
//!          precision or simpify curve2d. <br>
class ShapeCustom_Curve2d  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Check if poleses is in the plane with given precision <br>
//!          Returns false if no. <br>
Standard_EXPORT static  Standard_Boolean IsLinear(const TColgp_Array1OfPnt2d& thePoles,const Standard_Real theTolerance,Standard_Real& theDeviation) ;

//! Try to convert BSpline2d or Bezier2d to line 2d <br>
//!          only if it is linear. Recalculate first and last parameters. <br>
//!          Returns line2d or null curve2d. <br>
Standard_EXPORT static  Handle_Geom2d_Line ConvertToLine2d(const Handle(Geom2d_Curve)& theCurve,const Standard_Real theFirstIn,const Standard_Real theLastIn,const Standard_Real theTolerance,Standard_Real& theNewFirst,Standard_Real& theNewLast,Standard_Real& theDeviation) ;

//! Try to remove knots from bspline where local derivatives are the same. <br>
//!          Remove knots with given precision. <br>
//!          Returns false if Bsplien was not modified <br>
Standard_EXPORT static  Standard_Boolean SimplifyBSpline2d(Handle(Geom2d_BSplineCurve)& theBSpline2d,const Standard_Real theTolerance) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
