// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Select3D_SensitiveTriangulation_HeaderFile
#define _Select3D_SensitiveTriangulation_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Select3D_SensitiveTriangulation_HeaderFile
#include <Handle_Select3D_SensitiveTriangulation.hxx>
#endif

#ifndef _Handle_Poly_Triangulation_HeaderFile
#include <Handle_Poly_Triangulation.hxx>
#endif
#ifndef _TopLoc_Location_HeaderFile
#include <TopLoc_Location.hxx>
#endif
#ifndef _gp_Trsf_HeaderFile
#include <gp_Trsf.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TColgp_Array1OfPnt2d_HeaderFile
#include <TColgp_Array1OfPnt2d.hxx>
#endif
#ifndef _gp_Pnt2d_HeaderFile
#include <gp_Pnt2d.hxx>
#endif
#ifndef _Bnd_Box2d_HeaderFile
#include <Bnd_Box2d.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Select3D_SensitiveEntity_HeaderFile
#include <Select3D_SensitiveEntity.hxx>
#endif
#ifndef _Handle_SelectBasics_EntityOwner_HeaderFile
#include <Handle_SelectBasics_EntityOwner.hxx>
#endif
#ifndef _Handle_Select3D_SensitiveEntity_HeaderFile
#include <Handle_Select3D_SensitiveEntity.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Poly_Triangulation;
class TColStd_HArray1OfInteger;
class SelectBasics_EntityOwner;
class TopLoc_Location;
class gp_Pnt;
class Select3D_Projector;
class SelectBasics_ListOfBox2d;
class Select3D_SensitiveEntity;
class TColgp_Array1OfPnt2d;
class Bnd_Box2d;
class gp_Lin;
class gp_Pnt2d;
class gp_XY;


//! A framework to define selection of a sensitive entity made of a set of triangles. <br>
class Select3D_SensitiveTriangulation : public Select3D_SensitiveEntity {

public:
 // Methods PUBLIC
 // 

//! Constructs a sensitive triangulation object defined by <br>
//! the owner OwnerId, the triangulation aTriangulation, <br>
//! the location aLoc, and the flag InteriorFlag. <br>
Standard_EXPORT Select3D_SensitiveTriangulation(const Handle(SelectBasics_EntityOwner)& OwnerId,const Handle(Poly_Triangulation)& aTriangulation,const TopLoc_Location& aLoc,const Standard_Boolean InteriorFlag = Standard_True);

//! Constructs a sensitive triangulation object defined by <br>
//! the owner OwnerId, the triangulation aTriangulation, <br>
//! the location aLoc, the array of free edges <br>
//! thefreeedges, the center of gravity theCDG, and the flag InteriorFlag. <br>
//! As free edges and the center of gravity do not have <br>
//! to be computed later, this syntax reduces computation time. <br>
Standard_EXPORT Select3D_SensitiveTriangulation(const Handle(SelectBasics_EntityOwner)& OwnerId,const Handle(Poly_Triangulation)& aTriangulation,const TopLoc_Location& aLoc,const Handle(TColStd_HArray1OfInteger)& thefreeedges,const gp_Pnt& theCDG,const Standard_Boolean InteriorFlag);

//! projection of the sensitive primitive in order to <br>
//!          get 2D boxes for the Sort Algorithm <br>
Standard_EXPORT   void Project(const Select3D_Projector& aProjector) ;

//! stores in <boxes> the 2D Boxes which represent the sensitive face <br>
//!          in the selection algorithm. <br>
Standard_EXPORT   void Areas(SelectBasics_ListOfBox2d& boxes) ;


Standard_EXPORT   Handle_Select3D_SensitiveEntity GetConnected(const TopLoc_Location& aLocation) ;


Standard_EXPORT virtual  Standard_Boolean Matches(const Standard_Real X,const Standard_Real Y,const Standard_Real aTol,Standard_Real& DMin) ;


Standard_EXPORT virtual  Standard_Boolean Matches(const Standard_Real XMin,const Standard_Real YMin,const Standard_Real XMax,const Standard_Real YMax,const Standard_Real aTol) ;


Standard_EXPORT virtual  Standard_Boolean Matches(const TColgp_Array1OfPnt2d& Polyline,const Bnd_Box2d& aBox,const Standard_Real aTol) ;

//! give the depht of the last detected triangle <br>
//!          (center of gravity) <br>
Standard_EXPORT   Standard_Real ComputeDepth(const gp_Lin& EyeLine) const;
//! Returns the detected three nodes P1, P2, P3 constituting a triangle. <br>
//! This triangle is a component of the overall sensitive <br>
//! triangulation created at construction time. <br>
  Standard_Integer DetectedTriangle() const;
//! Returns the triangulation used at the time of construction. <br>
 const Handle_Poly_Triangulation& Triangulation() const;
//! Returns the 3D center of gravity used at the time of construction. <br>
 const gp_Pnt& CDG3D() const;
//! Returns the 2D center of gravity used at the time of construction. <br>
 const gp_Pnt2d& CDG2D() const;

//! Dmin gives the distance between the cdg and aPoint <br>
Standard_EXPORT   Standard_Integer Status(const gp_XY& p0,const gp_XY& p1,const gp_XY& p2,const gp_XY& aPoint,const Standard_Real aTol,Standard_Real& Dmin) const;

  Standard_Boolean HasInitLocation() const;

 const TopLoc_Location& GetInitLocation() const;


Standard_EXPORT virtual  void ResetLocation() ;


Standard_EXPORT virtual  void SetLocation(const TopLoc_Location& aLoc) ;


Standard_EXPORT virtual  void Dump(Standard_OStream& S,const Standard_Boolean FullDump = Standard_True) const;

//! gives the vertices of detected triangle... <br>
//!          for debug only <br>
Standard_EXPORT   Standard_Boolean DetectedTriangle(gp_Pnt& P1,gp_Pnt& P2,gp_Pnt& P3) const;
//Standard_EXPORT ~Select3D_SensitiveTriangulation();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Standard_Boolean IsFree(const Standard_Integer IndexOfTriangle,Standard_Integer& IndexinFree) const;


Standard_EXPORT   void ComputeTotalTrsf() ;


 // Fields PRIVATE
 //
Handle_Poly_Triangulation myTriangul;
TopLoc_Location myiniloc;
gp_Trsf myTrsf;
gp_Pnt myCDG3D;
Handle_TColStd_HArray1OfInteger myFreeEdges;
Standard_Boolean myIntFlag;
TColgp_Array1OfPnt2d myNodes2d;
gp_Pnt2d myCDG2D;
Bnd_Box2d mybox2d;
Standard_Integer myDetectedTr;


};


#include <Select3D_SensitiveTriangulation.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
