// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _PrsMgr_PresentationManager_HeaderFile
#define _PrsMgr_PresentationManager_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentationManager_HeaderFile
#include <Handle_PrsMgr_PresentationManager.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TColStd_ListOfTransient_HeaderFile
#include <TColStd_ListOfTransient.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentableObject_HeaderFile
#include <Handle_PrsMgr_PresentableObject.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Viewer_View_HeaderFile
#include <Handle_Viewer_View.hxx>
#endif
#ifndef _Handle_PrsMgr_Presentation_HeaderFile
#include <Handle_PrsMgr_Presentation.hxx>
#endif
class Standard_NoSuchObject;
class PrsMgr_PresentableObject;
class Viewer_View;
class PrsMgr_Presentation;


//! This class represents any kind of entity able to collect <br>
//!          representations of an object, to show or erase them. <br>
//!          Example: StructureManager from Graphic3d <br>
//!                   View from Graphic2d <br>
class PrsMgr_PresentationManager : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT virtual  Standard_Boolean Is3D() const = 0;

//! Displays the presentation of the object in the given <br>
//!          Presentation manager with the given mode. <br>
//!          The mode should be enumerated by the object which <br>
//!          inherits PresentableObject. <br>
Standard_EXPORT   void Display(const Handle(PrsMgr_PresentableObject)& aPresentableObject,const Standard_Integer aMode = 0) ;

//! erases the presentation of the object in the given <br>
//!          Presentation manager with the given mode. <br>
Standard_EXPORT   void Erase(const Handle(PrsMgr_PresentableObject)& aPresentableObject,const Standard_Integer aMode = 0) ;


//! Clears the presentation of the presentable object <br>
//! aPresentableObject in this framework with the <br>
//! display mode aMode. <br>
Standard_EXPORT virtual  void Clear(const Handle(PrsMgr_PresentableObject)& aPresentableObject,const Standard_Integer aMode = 0) ;

//! Highlights the presentation of the presentable object <br>
//! aPresentableObject in this framework with the display mode aMode. <br>
Standard_EXPORT   void Highlight(const Handle(PrsMgr_PresentableObject)& aPresentableObject,const Standard_Integer aMode = 0) ;

//! Removes highlighting from the presentation of the <br>
//! presentable object aPresentableObject in this <br>
//! framework with the display mode aMode. <br>
Standard_EXPORT   void Unhighlight(const Handle(PrsMgr_PresentableObject)& aPresentableObject,const Standard_Integer aMode = 0) ;


//! Sets the display priority aNewPrior   of the <br>
//! presentable object aPresentableObject in this <br>
//! framework with the display mode aMode. <br>
Standard_EXPORT   void SetDisplayPriority(const Handle(PrsMgr_PresentableObject)& aPresentableObject,const Standard_Integer amode,const Standard_Integer aNewPrior) const;


//! Returns the display priority of the presentable object <br>
//! aPresentableObject in this framework with the <br>
//! display mode aMode. <br>
Standard_EXPORT   Standard_Integer DisplayPriority(const Handle(PrsMgr_PresentableObject)& aPresentableObject,const Standard_Integer amode) const;

//! Returns true if the presentation of the presentable <br>
//! object aPresentableObject in this framework with the <br>
//! display mode aMode is displayed. <br>
Standard_EXPORT   Standard_Boolean IsDisplayed(const Handle(PrsMgr_PresentableObject)& aPresentableObject,const Standard_Integer aMode = 0) const;

//! Returns true if the presentation of the presentable <br>
//! object aPresentableObject in this framework with the <br>
//! display mode aMode is highlighted. <br>
Standard_EXPORT   Standard_Boolean IsHighlighted(const Handle(PrsMgr_PresentableObject)& aPresentableObject,const Standard_Integer aMode = 0) const;

//! Updates the presentation of the presentable object <br>
//! aPresentableObject in this framework with the display mode aMode. <br>
Standard_EXPORT   void Update(const Handle(PrsMgr_PresentableObject)& aPresentableObject,const Standard_Integer aMode = 0) const;

//! initializes the list of Prs to be displayed in transient mode <br>
Standard_EXPORT virtual  void BeginDraw() ;

//! Performs an iteration of the transient objects to look <br>
//! for the presentable objects with the display mode aMode. <br>
//! Appends the presentation of the presentable object <br>
//! aPresentableObject with the mode aMode to the list <br>
//! of objects in immediate mode. <br>
Standard_EXPORT   void Add(const Handle(PrsMgr_PresentableObject)& aPresentableObject,const Standard_Integer aMode = 0) ;

//! Performs an iteration of the transient objects to look <br>
//! for the presentable objects with the display mode aMode. <br>
//! Removes the presentation of the presentable object <br>
//! aPresentableObject with the mode aMode from the <br>
//! list of objects in immediate mode. <br>
Standard_EXPORT   void Remove(const Handle(PrsMgr_PresentableObject)& aPresentableObject,const Standard_Integer aMode = 0) ;

//!  Allows rapid drawing of the view aView by avoiding <br>
//! an update of the whole background. If DoubleBuffer <br>
//! is true, the background is drawn. <br>
Standard_EXPORT virtual  void EndDraw(const Handle(Viewer_View)& aView,const Standard_Boolean DoubleBuffer = Standard_False)  = 0;
//! Returns true if immediate (transient) mode is on. <br>
  Standard_Boolean IsImmediateModeOn() const;

//! Returns true if there is a presentation of the <br>
//! presentable object aPresentableObject in this <br>
//! framework, aPresentableObject having the display mode aMode. <br>
Standard_EXPORT   Standard_Boolean HasPresentation(const Handle(PrsMgr_PresentableObject)& aPresentableObject,const Standard_Integer aMode = 0) const;

//! Returns the presentation Presentation of the <br>
//! presentable object aPresentableObject in this <br>
//! framework. aPresentableObject has the display mode aMode. <br>
Standard_EXPORT   Handle_PrsMgr_Presentation Presentation(const Handle(PrsMgr_PresentableObject)& aPresentableObject,const Standard_Integer aMode = 0) const;
//Standard_EXPORT ~PrsMgr_PresentationManager();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


Standard_EXPORT PrsMgr_PresentationManager();

//! Adds a presentation of the presentable object <br>
//! aPresentableObject to this framework. <br>
//! aPresentableObject has the display mode aMode. <br>
Standard_EXPORT   void AddPresentation(const Handle(PrsMgr_PresentableObject)& aPresentableObject,const Standard_Integer aMode = 0) ;


 // Fields PROTECTED
 //
Standard_Boolean myImmediateMode;
TColStd_ListOfTransient myImmediateList;


private: 

 // Methods PRIVATE
 // 

//! Creates a new presentation in the presentation manager. <br>
Standard_EXPORT virtual  Handle_PrsMgr_Presentation newPresentation(const Handle(PrsMgr_PresentableObject)& aPresentableObject)  = 0;


 // Fields PRIVATE
 //


};


#include <PrsMgr_PresentationManager.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
