// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Prs3d_Arrow_HeaderFile
#define _Prs3d_Arrow_HeaderFile

#ifndef _Prs3d_Root_HeaderFile
#include <Prs3d_Root.hxx>
#endif
#ifndef _Handle_Prs3d_Presentation_HeaderFile
#include <Handle_Prs3d_Presentation.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
class Prs3d_Presentation;
class gp_Pnt;
class gp_Dir;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! provides class methods to draw an arrow at a given <br>
//!          location, along a given direction and using a given <br>
//!          angle. <br>
class Prs3d_Arrow  : public Prs3d_Root {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Defines the representation of the arrow defined by <br>
//! the location point aLocation, the direction <br>
//! aDirection and the length aLength. <br>
//! The angle anAngle defines the angle of opening of the arrow head. <br>
//! The presentation object aPresentation stores the <br>
//! information defined in this framework. <br>
Standard_EXPORT static  void Draw(const Handle(Prs3d_Presentation)& aPresentation,const gp_Pnt& aLocation,const gp_Dir& aDirection,const Quantity_PlaneAngle anAngle,const Quantity_Length aLength) ;

//! Defines the representation of the arrow defined by <br>
//! the location point aLocation, the direction vector <br>
//! aDirection and the length aLength. <br>
//! The angle anAngle defines the angle of opening of <br>
//! the arrow head, and the drawer aDrawer specifies <br>
//! the display attributes which arrows will have. <br>
//!  With this syntax, no presentation object is created. <br>
Standard_EXPORT static  void Fill(const Handle(Prs3d_Presentation)& aPresentation,const gp_Pnt& aLocation,const gp_Dir& aDirection,const Quantity_PlaneAngle anAngle,const Quantity_Length aLength) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
