#ifndef OPENGL_CMN_STG_TBL_H
#define OPENGL_CMN_STG_TBL_H

#define __CHAP1 0x70616863
#define __CHAP2 0x50414843

typedef struct CMN_STG_ELEM_STRUCT
{
  Tint    chap ;
  struct  CMN_STG_ELEM_STRUCT *next;
  Tchar   data[1];
} CMN_STG_ELEM, *cmn_stg_elem;

typedef struct CMN_STG_TBL_STRUCT
{
  Tint num;                     /* number of records in the table     */
  Tint size;                    /* adjusted size of rec               */
  cmn_stg_elem free_ptr;        /* free slot pointer                  */
  void *next_page;              /* next page pointer                  */
  Tint cur_no_rec ;             /* current no. of records             */
  Tint tot_no_rec ;             /* total no. of records               */
} CMN_STG_TBL, *cmn_stg_tbl;



extern  cmn_stg_tbl     cmn_stg_tbl_create( Tint, Tint ); /* num, size */
extern  TStatus         cmn_stg_tbl_kill( cmn_stg_tbl );
extern  void           *cmn_stg_tbl_get( cmn_stg_tbl );
extern  TStatus         cmn_stg_tbl_free( void* );

#endif
