// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _OSD_MailBox_HeaderFile
#define _OSD_MailBox_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _OSD_Function_HeaderFile
#include <OSD_Function.hxx>
#endif
#ifndef _OSD_Error_HeaderFile
#include <OSD_Error.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_ConstructionError;
class Standard_NullObject;
class OSD_OSDError;
class Standard_ProgramError;
class TCollection_AsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Establishes a mailbox with VMS-like-features and with <br>
//!          asynchronous functions. <br>
//!          The mail boxes are used to communicate asynchronously <br>
//!          between processes. <br>
//!          Basically MailBox facilities provide tools to communicate <br>
//!          between a client process and a server process. <br>
//!          The client process puts data/requests into the mail-box and <br>
//!          the server process gets these data/requests. In this context <br>
//!          client and server must run on the same machine. <br>
//!  Warning: On VMS, you need TMPMBX privilege. <br>
class OSD_MailBox  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! To be used with 'Open'. <br>
//!          It just allocates room for 'myName'. <br>
//!          This is for a client process. <br>
Standard_EXPORT OSD_MailBox();

//! Instantiates MailBox object with a name, size required <br>
//!          and a function to read mail boxes asynchronously. <br>
//!          Each process working with the same MailBox must use <br>
//!          a common known access : the mail-box's name. <br>
Standard_EXPORT OSD_MailBox(const TCollection_AsciiString& name,const Standard_Integer Size,const OSD_Function& Async_function);

//! Builds (physically) <me> into system. <br>
//!          <me> is created and ready to run. <br>
//!          This can be seen as an asynchronous server. <br>
Standard_EXPORT   void Build() ;

//! Opens mail box, and is ready to communicate with an <br>
//!          already created mailbox. <br>
//!          Raises NullObject when the name is a null string. <br>
//!          Raises ConstructionError when the name contains characters not <br>
//!          in range of ' '...'~'. <br>
//!          Raises ProgramError when the mail box has a null size. <br>
//!          This can be seen as a client. <br>
Standard_EXPORT   void Open(const TCollection_AsciiString& name,const Standard_Integer Size) ;

//! Removes the mail box from system. <br>
//!          This is used only by server process ! <br>
//!          Raises ProgramError when the mail box is already deleted. <br>
Standard_EXPORT   void Delete() ;

//! Writes a message of specified length into mail box. <br>
//!          <Message> is used as a buffer, not as a common string. <br>
//!          So this can be not null terminated like a 'char *'. <br>
//!          This is why <Length> is useful. <br>
//!          Raises ProgramError when the length of the data is either <br>
//!          negative or zero. <br>
//! <br>
Standard_EXPORT   void Write(const TCollection_AsciiString& Message,const Standard_Integer Length) ;

//! Returns TRUE if an error occurs <br>
Standard_EXPORT   Standard_Boolean Failed() const;

//! Resets error counter to zero <br>
Standard_EXPORT   void Reset() ;

//! Raises OSD_Error <br>
Standard_EXPORT   void Perror() ;

//! Returns error number if 'Failed' is TRUE. <br>
Standard_EXPORT   Standard_Integer Error() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myId;
TCollection_AsciiString myName;
Standard_Integer mySize;
OSD_Function myFunc;
OSD_Error myError;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
