// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MAT2d_Connexion_HeaderFile
#define _MAT2d_Connexion_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_MAT2d_Connexion_HeaderFile
#include <Handle_MAT2d_Connexion.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Pnt2d_HeaderFile
#include <gp_Pnt2d.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class gp_Pnt2d;


//! A Connexion links two lines of items  in a set <br>
//!          of  lines. It s contains two  points and their paramatric <br>
//!          definitions on the lines. <br>
//!          The items can be points or curves. <br>
class MAT2d_Connexion : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT MAT2d_Connexion();


Standard_EXPORT MAT2d_Connexion(const Standard_Integer LineA,const Standard_Integer LineB,const Standard_Integer ItemA,const Standard_Integer ItemB,const Standard_Real Distance,const Standard_Real ParameterOnA,const Standard_Real ParameterOnB,const gp_Pnt2d& PointA,const gp_Pnt2d& PointB);

//!  Returns the Index on the first line. <br>
Standard_EXPORT   Standard_Integer IndexFirstLine() const;

//!  Returns the Index on the Second line. <br>
Standard_EXPORT   Standard_Integer IndexSecondLine() const;

//! Returns the Index of the item on the first line. <br>
Standard_EXPORT   Standard_Integer IndexItemOnFirst() const;

//! Returns the Index of the item on the second line. <br>
Standard_EXPORT   Standard_Integer IndexItemOnSecond() const;

//! Returns the parameter of the point on the firstline. <br>
Standard_EXPORT   Standard_Real ParameterOnFirst() const;

//! Returns the parameter of the point on the secondline. <br>
Standard_EXPORT   Standard_Real ParameterOnSecond() const;

//! Returns the point on the firstline. <br>
Standard_EXPORT   gp_Pnt2d PointOnFirst() const;

//! Returns the point on the secondline. <br>
Standard_EXPORT   gp_Pnt2d PointOnSecond() const;

//! Returns the distance between the two points. <br>
Standard_EXPORT   Standard_Real Distance() const;


Standard_EXPORT   void IndexFirstLine(const Standard_Integer anIndex) ;


Standard_EXPORT   void IndexSecondLine(const Standard_Integer anIndex) ;


Standard_EXPORT   void IndexItemOnFirst(const Standard_Integer anIndex) ;


Standard_EXPORT   void IndexItemOnSecond(const Standard_Integer anIndex) ;


Standard_EXPORT   void ParameterOnFirst(const Standard_Real aParameter) ;


Standard_EXPORT   void ParameterOnSecond(const Standard_Real aParameter) ;


Standard_EXPORT   void PointOnFirst(const gp_Pnt2d& aPoint) ;


Standard_EXPORT   void PointOnSecond(const gp_Pnt2d& aPoint) ;


Standard_EXPORT   void Distance(const Standard_Real aDistance) ;

//! Returns the reverse connexion of <me>. <br>
//!          the firstpoint  is the secondpoint. <br>
//!          the secondpoint is the firstpoint. <br>
Standard_EXPORT   Handle_MAT2d_Connexion Reverse() const;

//! Returns <True> if my firstPoint is on the same line <br>
//!          than the firstpoint of <aConnexion> and my firstpoint <br>
//!          is after the firstpoint of <aConnexion> on the line. <br>
//!          <aSense> = 1 if <aConnexion> is on the Left of its <br>
//!          firstline, else <aSense> = -1. <br>
Standard_EXPORT   Standard_Boolean IsAfter(const Handle(MAT2d_Connexion)& aConnexion,const Standard_Real aSense) const;

//! Print <me>. <br>
Standard_EXPORT   void Dump(const Standard_Integer Deep = 0,const Standard_Integer Offset = 0) const;
//Standard_EXPORT ~MAT2d_Connexion();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer lineA;
Standard_Integer lineB;
Standard_Integer itemA;
Standard_Integer itemB;
Standard_Real distance;
Standard_Real parameterOnA;
Standard_Real parameterOnB;
gp_Pnt2d pointA;
gp_Pnt2d pointB;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
