// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _LProp3d_CurveTool_HeaderFile
#define _LProp3d_CurveTool_HeaderFile

#ifndef _Handle_Adaptor3d_HCurve_HeaderFile
#include <Handle_Adaptor3d_HCurve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Adaptor3d_HCurve;
class gp_Pnt;
class gp_Vec;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class LProp3d_CurveTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Computes the point <P> of parameter <U> on the HCurve <C>. <br>
Standard_EXPORT static  void Value(const Handle(Adaptor3d_HCurve)& C,const Standard_Real U,gp_Pnt& P) ;

//! Computes the point <P> and first derivative <V1> of <br>
//!          parameter <U> on the HCurve <C>. <br>
Standard_EXPORT static  void D1(const Handle(Adaptor3d_HCurve)& C,const Standard_Real U,gp_Pnt& P,gp_Vec& V1) ;

//! Computes the point <P>, the first derivative <V1> and second <br>
//!          derivative <V2> of parameter <U> on the HCurve <C>. <br>
Standard_EXPORT static  void D2(const Handle(Adaptor3d_HCurve)& C,const Standard_Real U,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2) ;

//! Computes the point <P>, the first derivative <V1>, the <br>
//!          second derivative <V2> and third derivative <V3> of <br>
//!          parameter <U> on the HCurve <C>. <br>
Standard_EXPORT static  void D3(const Handle(Adaptor3d_HCurve)& C,const Standard_Real U,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2,gp_Vec& V3) ;

//! returns the order of continuity of the HCurve <C>. <br>
//!          returns 1 : first derivative only is computable <br>
//!          returns 2 : first and second derivative only are computable. <br>
//!          returns 3 : first, second and third are computable. <br>
Standard_EXPORT static  Standard_Integer Continuity(const Handle(Adaptor3d_HCurve)& C) ;

//! returns the first parameter bound of the HCurve. <br>
//! <br>
Standard_EXPORT static  Standard_Real FirstParameter(const Handle(Adaptor3d_HCurve)& C) ;

//! returns the last parameter bound of the HCurve. <br>
//!          FirstParameter must be less than LastParamenter. <br>
Standard_EXPORT static  Standard_Real LastParameter(const Handle(Adaptor3d_HCurve)& C) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
