// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Intf_HeaderFile
#define _Intf_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class gp_Pnt;
class gp_XYZ;
class Intf_ToolPolygon;
class Intf_ToolPolyhedron;
class Intf_Array1OfLin;
class Intf_SectionPoint;
class Intf_SeqOfSectionPoint;
class Intf_SectionLine;
class Intf_SeqOfSectionLine;
class Intf_TangentZone;
class Intf_SeqOfTangentZone;
class Intf_Interference;
class Intf_Tool;
class Intf_InterferencePolygon2d;
class Intf_InterferencePolygon3d;
class Intf_InterferencePolygonPolyhedron;
class Intf_InterferencePolyhedron;
class Intf_SequenceNodeOfSeqOfSectionPoint;
class Intf_SequenceNodeOfSeqOfTangentZone;
class Intf_SequenceNodeOfSeqOfSectionLine;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Interference computation  between polygons, lines  and <br>
//!          polyhedra with only  triangular  facets. These objects <br>
//!          are polygonal  representations of complex   curves and <br>
//!          triangulated representations of complex surfaces. <br>
class Intf  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Give the plane equation of the triangle <P1> <P2> <P3>. <br>
Standard_EXPORT static  void PlaneEquation(const gp_Pnt& P1,const gp_Pnt& P2,const gp_Pnt& P3,gp_XYZ& NormalVector,Standard_Real& PolarDistance) ;

//! Compute if the triangle <P1> <P2> <P3> contain <ThePnt>. <br>
Standard_EXPORT static  Standard_Boolean Contain(const gp_Pnt& P1,const gp_Pnt& P2,const gp_Pnt& P3,const gp_Pnt& ThePnt) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class Intf_ToolPolygon;
friend class Intf_ToolPolyhedron;
friend class Intf_Array1OfLin;
friend class Intf_SectionPoint;
friend class Intf_SeqOfSectionPoint;
friend class Intf_SectionLine;
friend class Intf_SeqOfSectionLine;
friend class Intf_TangentZone;
friend class Intf_SeqOfTangentZone;
friend class Intf_Interference;
friend class Intf_Tool;
friend class Intf_InterferencePolygon2d;
friend class Intf_InterferencePolygon3d;
friend class Intf_InterferencePolygonPolyhedron;
friend class Intf_InterferencePolyhedron;
friend class Intf_SequenceNodeOfSeqOfSectionPoint;
friend class Intf_SequenceNodeOfSeqOfTangentZone;
friend class Intf_SequenceNodeOfSeqOfSectionLine;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
