// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Interface_GraphContent_HeaderFile
#define _Interface_GraphContent_HeaderFile

#ifndef _Interface_EntityIterator_HeaderFile
#include <Interface_EntityIterator.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
class Interface_Graph;
class Standard_Transient;
class Interface_EntityIterator;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Defines general form for classes of graph algorithms on <br>
//!           Interfaces, this form is that of EntityIterator <br>
//!           Each sub-class fills it according to its own algorithm <br>
//!           This also allows to combine any graph result to others, <br>
//!           all being given under one unique form <br>
class Interface_GraphContent  : public Interface_EntityIterator {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an empty GraphContent, ready to be filled <br>
Standard_EXPORT Interface_GraphContent();

//! Creates with all entities designated by a Graph <br>
Standard_EXPORT Interface_GraphContent(const Interface_Graph& agraph);

//! Creates with entities having specific Status value in a Graph <br>
Standard_EXPORT Interface_GraphContent(const Interface_Graph& agraph,const Standard_Integer stat);

//! Creates an Iterator with Shared entities of an entity <br>
//!           (equivalente to EntityIterator but with a Graph) <br>
Standard_EXPORT Interface_GraphContent(const Interface_Graph& agraph,const Handle(Standard_Transient)& ent);

//! Gets all Entities designated by a Graph (once created), adds <br>
//!           them to those already recorded <br>
Standard_EXPORT   void GetFromGraph(const Interface_Graph& agraph) ;

//! Gets entities from a graph which have a specific Status value <br>
//!           (one created), adds them to those already recorded <br>
Standard_EXPORT   void GetFromGraph(const Interface_Graph& agraph,const Standard_Integer stat) ;

//! Returns Result under the exact form of an EntityIterator : <br>
//!           Can be used when EntityIterator itself is required (as a <br>
//!           returned value for instance), whitout way for a sub-class <br>
Standard_EXPORT   Interface_EntityIterator Result() ;

//! Does the Evaluation before starting the iteration itself <br>
//!           (in out) <br>
Standard_EXPORT   void Begin() ;

//! Evaluates list of Entities to be iterated. Called by Start <br>
//!           Default is set to doing nothing : intended to be redefined <br>
//!           by each sub-class <br>
Standard_EXPORT virtual  void Evaluate() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
