// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Interface_Graph_HeaderFile
#define _Interface_Graph_HeaderFile

#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _TColStd_Array1OfInteger_HeaderFile
#include <TColStd_Array1OfInteger.hxx>
#endif
#ifndef _Interface_BitMap_HeaderFile
#include <Interface_BitMap.hxx>
#endif
#ifndef _Interface_IntList_HeaderFile
#include <Interface_IntList.hxx>
#endif
#ifndef _Handle_Interface_Protocol_HeaderFile
#include <Handle_Interface_Protocol.hxx>
#endif
#ifndef _Handle_Interface_GTool_HeaderFile
#include <Handle_Interface_GTool.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_Standard_Type_HeaderFile
#include <Handle_Standard_Type.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
class Interface_InterfaceModel;
class Standard_DomainError;
class Interface_GeneralLib;
class Interface_Protocol;
class Interface_GTool;
class Interface_IntList;
class Standard_Transient;
class Interface_BitMap;
class Interface_EntityIterator;
class Standard_Type;
class TCollection_HAsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Gives basic data structure for operating and storing <br>
//!           graph results (usage is normally internal) <br>
//!           Entities are Mapped according their Number in the Model <br>
//! <br>
//!           Each Entity from the Model can be known as "Present" or <br>
//!           not; if it is, it is Mapped with a Status : an Integer <br>
//!           which can be used according to needs of each algorithm <br>
//!           In addition, the Graph brings a BitMap which can be used <br>
//!           by any caller <br>
//! <br>
//!           Also, it is bound with two lists : a list of Shared <br>
//!           Entities (in fact, their Numbers in the Model) which is <br>
//!           filled by a ShareTool, and a list of Sharing Entities, <br>
//!           computed by deduction from the Shared Lists <br>
//! <br>
//!           Moreover, it is possible to redefine the list of Entities <br>
//!           Shared by an Entity (instead of standard answer by general <br>
//!           service Shareds) : this new list can be empty; it can <br>
//!           be changed or reset (i.e. to come back to standard answer) <br>
class Interface_Graph  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an empty graph, ready to receive Entities from amodel <br>
//!           Note that this way of Creation allows <me> to verify that <br>
//!           Entities to work with are contained in <amodel> <br>
//!           Basic Shared and Sharing lists are obtained from a General <br>
//!           Services Library, given directly as an argument <br>
Standard_EXPORT Interface_Graph(const Handle(Interface_InterfaceModel)& amodel,const Interface_GeneralLib& lib);

//! Same as above, but the Library is defined through a Protocol <br>
Standard_EXPORT Interface_Graph(const Handle(Interface_InterfaceModel)& amodel,const Handle(Interface_Protocol)& protocol);

//! Same as above, but the Library is defined through a Protocol <br>
Standard_EXPORT Interface_Graph(const Handle(Interface_InterfaceModel)& amodel,const Handle(Interface_GTool)& gtool);

//! Same a above but works with the Protocol recorded in the Model <br>
Standard_EXPORT Interface_Graph(const Handle(Interface_InterfaceModel)& amodel);

//! Creates a Graph from another one, getting all its data <br>
//!           Remark that status are copied from <agraph>, but the other <br>
//!           lists (sharing/shared) are copied only if <copied> = True <br>
Standard_EXPORT Interface_Graph(const Interface_Graph& agraph,const Standard_Boolean copied = Standard_False);

//! Reevaluates the Sharing Lists of the Graph, starting from the <br>
//!           Shared Lists (priority to the redefined ones) <br>
Standard_EXPORT   void EvalSharings() ;

//! Erases data, making graph ready to rebegin from void <br>
//!           (also resets Shared lists redefinitions) <br>
Standard_EXPORT   void Reset() ;

//! Erases Status (Values and Flags of Presence), making graph <br>
//!           ready to rebegin from void. Does not concerns Shared lists <br>
Standard_EXPORT   void ResetStatus() ;

//! Returns size (max nb of entities, i.e. Model's nb of entities) <br>
Standard_EXPORT   Standard_Integer Size() const;

//! Returns the Number of the entity in the Map, computed at <br>
//!           creation time (Entities loaded from the Model) <br>
//!           Returns 0 if <ent> not contained by Model used to create <me> <br>
//!           (that is, <ent> is unknown from <me>) <br>
Standard_EXPORT   Standard_Integer EntityNumber(const Handle(Standard_Transient)& ent) const;

//! Returns True if an Entity is noted as present in the graph <br>
//!           (See methods Get... which determine this status) <br>
//!           Returns False if <num> is out of range too <br>
Standard_EXPORT   Standard_Boolean IsPresent(const Standard_Integer num) const;

//! Same as above but directly on an Entity <ent> : if it is not <br>
//!           contained in the Model, returns False. Else calls <br>
//!            IsPresent(num)  with <num> given by EntityNumber <br>
Standard_EXPORT   Standard_Boolean IsPresent(const Handle(Standard_Transient)& ent) const;

//! Returns mapped Entity given its no (if it is present) <br>
Standard_EXPORT  const Handle_Standard_Transient& Entity(const Standard_Integer num) const;

//! Returns Status associated to a numero (only to read it) <br>
Standard_EXPORT   Standard_Integer Status(const Standard_Integer num) const;

//! Returns Status associated to a numero, to be read or changed <br>
Standard_EXPORT   Standard_Integer& CStatus(const Standard_Integer num) ;

//! Modifies Status associated to a numero <br>
Standard_EXPORT   void SetStatus(const Standard_Integer num,const Standard_Integer stat) ;

//! Clears Entity and sets Status to 0, for a numero <br>
Standard_EXPORT   void RemoveItem(const Standard_Integer num) ;

//! Changes all status which value is oldstat to new value newstat <br>
Standard_EXPORT   void ChangeStatus(const Standard_Integer oldstat,const Standard_Integer newstat) ;

//! Removes all items of which status has a given value stat <br>
Standard_EXPORT   void RemoveStatus(const Standard_Integer stat) ;

//! Returns the Bit Map in order to read or edit flag values <br>
Standard_EXPORT  const Interface_BitMap& BitMap() const;

//! Returns the Bit Map in order to edit it (add new flags) <br>
Standard_EXPORT   Interface_BitMap& CBitMap() ;

//! Returns the Model with which this Graph was created <br>
Standard_EXPORT  const Handle_Interface_InterfaceModel& Model() const;

//! Loads Graph with all Entities contained in the Model <br>
Standard_EXPORT   void GetFromModel() ;

//! Gets an Entity, plus its shared ones (at every level) if <br>
//!           "shared" is True. New items are set to status "newstat" <br>
//!           Items already present in graph remain unchanged <br>
//!           Of course, redefinitions of Shared lists are taken into <br>
//!           account if there are some <br>
Standard_EXPORT   void GetFromEntity(const Handle(Standard_Transient)& ent,const Standard_Boolean shared,const Standard_Integer newstat = 0) ;

//! Gets an Entity, plus its shared ones (at every level) if <br>
//!           "shared" is True. New items are set to status "newstat". <br>
//!           Items already present in graph are processed as follows : <br>
//!           - if they already have status "newstat", they remain unchanged <br>
//!           - if they have another status, this one is modified : <br>
//!             if cumul is True,  to former status + overlapstat (cumul) <br>
//!             if cumul is False, to overlapstat (enforce) <br>
Standard_EXPORT   void GetFromEntity(const Handle(Standard_Transient)& ent,const Standard_Boolean shared,const Standard_Integer newstat,const Standard_Integer overlapstat,const Standard_Boolean cumul) ;

//! Gets Entities given by an EntityIterator. Entities which were <br>
//!           not yet present in the graph are mapped with status "newstat" <br>
//!           Entities already present remain unchanged <br>
Standard_EXPORT   void GetFromIter(const Interface_EntityIterator& iter,const Standard_Integer newstat) ;

//! Gets Entities given by an EntityIterator and distinguishes <br>
//!           those already present in the Graph : <br>
//!           - new entities added to the Graph with status "newstst" <br>
//!           - entities already present with status = "newstat" remain <br>
//!             unchanged <br>
//!           - entities already present with status different form <br>
//!             "newstat" have their status modified : <br>
//!             if cumul is True,  to former status + overlapstat (cumul) <br>
//!             if cumul is False, to overlapstat (enforce) <br>
//!             (Note : works as GetEntity, shared = False, for each entity) <br>
Standard_EXPORT   void GetFromIter(const Interface_EntityIterator& iter,const Standard_Integer newstat,const Standard_Integer overlapstat,const Standard_Boolean cumul) ;

//! Gets all present items from another graph <br>
Standard_EXPORT   void GetFromGraph(const Interface_Graph& agraph) ;

//! Gets items from another graph which have a specific Status <br>
Standard_EXPORT   void GetFromGraph(const Interface_Graph& agraph,const Standard_Integer stat) ;

//! Returns True if <ent> or the list of entities shared by <ent> <br>
//!           (not redefined) contains items unknown from this Graph <br>
//!           Remark : apart from the status HasShareError, these items <br>
//!           are ignored <br>
Standard_EXPORT   Standard_Boolean HasShareErrors(const Handle(Standard_Transient)& ent) const;

//! Returns True if Shared list of <ent> has been redefined <br>
//!           (Thus, Shareds from Graph gives a result different from <br>
//!            general service Shareds) <br>
Standard_EXPORT   Standard_Boolean HasRedefinedShareds(const Handle(Standard_Transient)& ent) const;

//! Returns the list of Entities Shared by an Entity, as recorded <br>
//!           by the Graph. That is, by default Basic Shared List, else it <br>
//!           can be redefined by methods SetShare, SetNoShare ... see below <br>
Standard_EXPORT   Interface_EntityIterator Shareds(const Handle(Standard_Transient)& ent) const;

//! Same as Shareds, but under the form of a list of Integers, <br>
//!           each one beeing the Number of a Shared Entity in the Graph <br>
//!           Especially intended for fast internal uses <br>
//!           Returns a Null Handle if <num> is not contained by <themodel> <br>
Standard_EXPORT   Interface_IntList SharedNums(const Standard_Integer num) const;

//! Returns the list of Entities which Share an Entity, computed <br>
//!           from the Basic or Redefined Shared Lists <br>
Standard_EXPORT   Interface_EntityIterator Sharings(const Handle(Standard_Transient)& ent) const;

//! Same as Sharings, but under the form of a list of Integers <br>
//!           each one beeing the Number of a Sharing Entity in the Graph <br>
Standard_EXPORT   Interface_IntList SharingNums(const Standard_Integer num) const;

//! Returns the list of sharings entities, AT ANY LEVEL, which are <br>
//!           kind of a given type. A sharing entity kind of this type <br>
//!           ends the exploration of its branch <br>
Standard_EXPORT   Interface_EntityIterator TypedSharings(const Handle(Standard_Transient)& ent,const Handle(Standard_Type)& type) const;

//! Returns the Entities which are not Shared (their Sharing List <br>
//!           is empty) in the Model <br>
Standard_EXPORT   Interface_EntityIterator RootEntities() const;

//! Sets explicit the shared list of an Entity <ent>, that is, <br>
//!           available for a further edit (Add/Remove). All SetShare and <br>
//!           SetNoShare methods allow further edit operations. <br>
//!           Effect cancelled by ResetShare <br>
//!           Remark that all Redefinition methods work on Shared Lists, <br>
//!           but also manage (update) the Sharing Lists <br>
Standard_EXPORT   void SetShare(const Handle(Standard_Transient)& ent) ;

//! Sets as Shared list of an Entity <ent> considered by <me>, <br>
//!           the list given as an EntityIterator <iter>. It can be empty. <br>
//!           This list will now be considered by method Shareds above <br>
//!           Does nothing if <ent> is not contained by <themodel> <br>
Standard_EXPORT   void SetShare(const Handle(Standard_Transient)& ent,const Interface_EntityIterator& list) ;

//! Same as above, but the list is given as the list of Numbers <br>
//!           of the Entities shared by <ent> <br>
Standard_EXPORT   void SetShare(const Handle(Standard_Transient)& ent,const Interface_IntList& list) ;

//! Sets the Shared list of an Entity considered in <me> as beeing <br>
//!           Empty (if <ent> is contained by <themodel>) <br>
Standard_EXPORT   void SetNoShare(const Handle(Standard_Transient)& ent) ;

//! Sets the Shared lists of a list of Entities to be Empty <br>
Standard_EXPORT   void SetNoShare(const Interface_EntityIterator& list) ;

//! Adds a shared Entity to a redefined Shared List (formerly <br>
//!           defined by SetShare or SetNoShare). Does nothing if already in <br>
Standard_EXPORT   void AddShared(const Handle(Standard_Transient)& ent,const Handle(Standard_Transient)& shared) ;

//! Removes a shared Entity from a redefined Shared List (formerly <br>
//!           defined ...). Does nothing if <shared> no in the list <br>
Standard_EXPORT   void RemoveShared(const Handle(Standard_Transient)& ent,const Handle(Standard_Transient)& shared) ;

//! Comes back to the standard Shared list for <ent> : Cancels all <br>
//!           the former redefinitions for it <br>
Standard_EXPORT   void ResetShare(const Handle(Standard_Transient)& ent) ;

//! Clears all effects of former redefinition of Shared lists <br>
Standard_EXPORT   void ResetAllShare() ;

//! Determines the name attached to an entity, by using the <br>
//!           general service Name in GeneralModule <br>
//!           Returns a null handle if no name could be computed or if <br>
//!           the entity is not in the model <br>
Standard_EXPORT   Handle_TCollection_HAsciiString Name(const Handle(Standard_Transient)& ent) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Performs the Evaluation of the Graph, from an initial Library, <br>
//!           either defined through a Protocol, or given dierctly <br>
//!           Called by the non-empty Constructors <br>
//! <br>
//!           Normally, gtool suffices. But if a Graph is created from a <br>
//!           GeneralLib directly, it cannot be used <br>
//!           If <gtool> is defined, it has priority <br>
Standard_EXPORT   void Evaluate(const Interface_GeneralLib& lib,const Handle(Interface_GTool)& gtool) ;

//! Returns the Table of Basic Shared lists. Used to Create <br>
//!           another Graph from <me> <br>
Standard_EXPORT   Interface_IntList BasicSharedTable() const;

//! Returns the Table of redefined Shared lists. Used to Create <br>
//!           another Graph from <me>. Null Handle is no one redefinition <br>
Standard_EXPORT   Interface_IntList RedefinedSharedTable() const;

//! Returns the Table of Sharing lists. Used to Create <br>
//!           another Graph from <me> <br>
Standard_EXPORT   Interface_IntList SharingTable() const;


 // Fields PRIVATE
 //
Handle_Interface_InterfaceModel themodel;
TCollection_AsciiString thepresents;
TColStd_Array1OfInteger thestats;
Interface_BitMap theflags;
Interface_IntList theshareds;
Interface_IntList thesharnews;
Interface_IntList thesharings;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
