// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntCurve_ProjectOnPConicTool_HeaderFile
#define _IntCurve_ProjectOnPConicTool_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class IntCurve_PConic;
class gp_Pnt2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class provides a tool which computes the parameter <br>
//!          of a point near a parametric conic. <br>
class IntCurve_ProjectOnPConicTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//!  Returns  the parameter V  of the  point   on the <br>
//!  parametric  curve corresponding to  the  Point  Pnt.   The <br>
//!  Correspondance between  Pnt  and the  point   P(V) on  the <br>
//!  parametric    curve  must  be  coherent with    the way of <br>
//!  determination  of the signed  distance between a point and <br>
//!  the implicit curve.  Tol is the tolerance on  the distance <br>
//!  between a point and the parametrised curve.  In that case, <br>
//!  no bounds are given.  The research  of the rigth parameter <br>
//!  has to  be  made  on the natural  parametric domain of the <br>
//!  curve. <br>
Standard_EXPORT static  Standard_Real FindParameter(const IntCurve_PConic& C,const gp_Pnt2d& Pnt,const Standard_Real Tol) ;

//!  Returns the  parameter  V of the   point  on the <br>
//!  parametric  curve corresponding  to  the   Point Pnt.  The <br>
//!  Correspondance  between Pnt and  the   point  P(V) on  the <br>
//!  parametric  curve  must  be  coherent   with the  way   of <br>
//!  determination of the  signed distance between  a point and <br>
//!  the implicit curve.  Tol  is the tolerance on the distance <br>
//!  between a point and the  parametrised curve.  LowParameter <br>
//!  and HighParameter give the  boundaries of the interval  in <br>
//!  wich the parameter  certainly  lies.  These parameters are <br>
//!  given to implement a  more efficient  algoritm. So,  it is <br>
//!  not necessary to check   that the returned value  verifies <br>
//!  LowParameter <= Value <= HighParameter. <br>
Standard_EXPORT static  Standard_Real FindParameter(const IntCurve_PConic& C,const gp_Pnt2d& Pnt,const Standard_Real LowParameter,const Standard_Real HighParameter,const Standard_Real Tol) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
