// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntAna_IntQuadQuad_HeaderFile
#define _IntAna_IntQuadQuad_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _IntAna_Curve_HeaderFile
#include <IntAna_Curve.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_OutOfRange;
class StdFail_NotDone;
class Standard_DomainError;
class gp_Cylinder;
class IntAna_Quadric;
class gp_Cone;
class IntAna_Curve;
class gp_Pnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class provides the analytic intersection between a <br>
//!          cylinder or a cone from gp and another quadric, as defined <br>
//!          in the class Quadric from IntAna. <br>
//!          This algorithm is used when the geometric intersection <br>
//!          (class QuadQuadGeo from IntAna) returns no geometric <br>
//!          solution. <br>
//!          The result of the intersection may be <br>
//!           - Curves as defined in the class Curve from IntAna <br>
//!           - Points (Pnt from gp) <br>
class IntAna_IntQuadQuad  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Empty Constructor <br>
Standard_EXPORT IntAna_IntQuadQuad();

//! Creates the intersection between a cylinder and a quadric . <br>
//!          Tol est a definir plus precisemment. <br>
Standard_EXPORT IntAna_IntQuadQuad(const gp_Cylinder& C,const IntAna_Quadric& Q,const Standard_Real Tol);

//! Creates the intersection between a cone and a quadric. <br>
//!          Tol est a definir plus precisemment. <br>
Standard_EXPORT IntAna_IntQuadQuad(const gp_Cone& C,const IntAna_Quadric& Q,const Standard_Real Tol);

//! Intersects a cylinder and a quadric . <br>
//!          Tol est a definir plus precisemment. <br>
Standard_EXPORT   void Perform(const gp_Cylinder& C,const IntAna_Quadric& Q,const Standard_Real Tol) ;

//! Intersects a cone and a quadric. <br>
//!          Tol est a definir plus precisemment. <br>
Standard_EXPORT   void Perform(const gp_Cone& C,const IntAna_Quadric& Q,const Standard_Real Tol) ;
//! Returns True if the computation was successful. <br>
//! <br>
  Standard_Boolean IsDone() const;
//! Returns TRUE if the cylinder, the cone or the sphere <br>
//!          is identical to the quadric. <br>
//! <br>
  Standard_Boolean IdenticalElements() const;
//! Returns the number of curves solution. <br>
//! <br>
  Standard_Integer NbCurve() const;

//! Returns the curve of range N. <br>
//! <br>
Standard_EXPORT  const IntAna_Curve& Curve(const Standard_Integer N) const;
//! Returns the number of contact point. <br>
//! <br>
  Standard_Integer NbPnt() const;

//! Returns the point of range N. <br>
//! <br>
Standard_EXPORT  const gp_Pnt& Point(const Standard_Integer N) const;

//! Returns  the paramaters on the  "explicit quadric" <br>
//!          (i.e  the cylinder or the  cone, the <br>
//!          first argument   given to the constructor)  of the <br>
//!          point of  range  N. <br>
Standard_EXPORT   void Parameters(const Standard_Integer N,Standard_Real& U1,Standard_Real& U2) const;

//! Returns True if the Curve I  shares its last bound <br>
//!          with another curve. <br>
Standard_EXPORT   Standard_Boolean HasNextCurve(const Standard_Integer I) const;

//! If  HasNextCurve(I)  returns True,  this  function <br>
//!          returns  the  Index J  of the curve  which   has a <br>
//!          common bound  with the curve   I.  If  Opposite == <br>
//!          True , then the last parameter of the curve I, and <br>
//!          the last parameter of  the curve J  give  the same <br>
//!          point. Else the last  parameter of the curve I and <br>
//!          the first parameter  of  the curve J are  the same <br>
//!          point. <br>
Standard_EXPORT   Standard_Integer NextCurve(const Standard_Integer I,Standard_Boolean& Opposite) const;

//! Returns True if the Curve I shares its first bound <br>
//!          with another curve. <br>
Standard_EXPORT   Standard_Boolean HasPreviousCurve(const Standard_Integer I) const;

//! if HasPreviousCurve(I) returns True, this function <br>
//!          returns the   Index  J of the   curve  which has a <br>
//!          common  bound with the  curve  I.  If Opposite  == <br>
//!          True  , then the  first parameter of  the curve I, <br>
//!          and the first parameter of the curve  J  give  the <br>
//!          same point. Else the first  parameter of the curve <br>
//!          I and the last  parameter  of the curve J  are the <br>
//!          same point. <br>
Standard_EXPORT   Standard_Integer PreviousCurve(const Standard_Integer I,Standard_Boolean& Opposite) const;





protected:

 // Methods PROTECTED
 // 

//! Set the next and previous fields. Private method. <br>
Standard_EXPORT   void InternalSetNextAndPrevious() ;


 // Fields PROTECTED
 //
Standard_Boolean done;
Standard_Boolean identical;
IntAna_Curve TheCurve[12];
Standard_Integer previouscurve[12];
Standard_Integer nextcurve[12];
Standard_Integer NbCurves;
Standard_Integer Nbpoints;
gp_Pnt Thepoints[2];
Standard_Integer myNbMaxCurves;
Standard_Real myEpsilon;
Standard_Real myEpsilonCoeffPolyNull;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};


#include <IntAna_IntQuadQuad.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
