// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Image_ColorImage_HeaderFile
#define _Image_ColorImage_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Image_ColorImage_HeaderFile
#include <Handle_Image_ColorImage.hxx>
#endif

#ifndef _Image_DColorImage_HeaderFile
#include <Image_DColorImage.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Aspect_GenericColorMap_HeaderFile
#include <Handle_Aspect_GenericColorMap.hxx>
#endif
#ifndef _Image_TypeOfImage_HeaderFile
#include <Image_TypeOfImage.hxx>
#endif
#ifndef _Handle_Image_Image_HeaderFile
#include <Handle_Image_Image.hxx>
#endif
class Aspect_ColorPixel;
class Aspect_GenericColorMap;
class Quantity_Color;
class Image_Image;


//! A ColorImage is a DColorImage with specific method. <br>
//!	     Each Pixel in the Image ,as a ColorPixel <br>
//!	     from Aspect, can be use directly as a Color. <br>
//! A ColorImage is also called a "true color image". <br>
class Image_ColorImage : public Image_DColorImage {

public:
 // Methods PUBLIC
 // 

//! Create a ColorImage object. <br>
//!	       The default Background Pixel is set to Black . <br>
//!	       All the Image is initialised with Background Pixel <br>
Standard_EXPORT Image_ColorImage(const Standard_Integer x,const Standard_Integer y,const Standard_Integer dx,const Standard_Integer dy);

//! Create a ColorImage object and set the Background Pixel. <br>
//!	       All the Image is initialised with Background Pixel <br>
Standard_EXPORT Image_ColorImage(const Standard_Integer x,const Standard_Integer y,const Standard_Integer dx,const Standard_Integer dy,const Aspect_ColorPixel& BackPixel);

//! Create a GenericColorMap object with the best ColorMap <br>
//!	of a particular size to use in Dithering method . <br>
//!	The best ColorMap is defined to be the one that contains as <br>
//!	many as possible of the most frequently used colors. <br>
Standard_EXPORT   Handle_Aspect_GenericColorMap ChooseColorMap(const Standard_Integer aSize) const;

//! Returns the Image Type. <br>
Standard_EXPORT   Image_TypeOfImage Type() const;

//! Returns the Pixel Color . <br>
Standard_EXPORT  const Quantity_Color& PixelColor(const Standard_Integer X,const Standard_Integer Y) const;

//! Duplicates a Image. <br>
Standard_EXPORT   Handle_Image_Image Dup() const;
//Standard_EXPORT ~Image_ColorImage();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
