// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSelect_SelectName_HeaderFile
#define _IGESSelect_SelectName_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSelect_SelectName_HeaderFile
#include <Handle_IGESSelect_SelectName.hxx>
#endif

#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _IFSelect_SelectExtract_HeaderFile
#include <IFSelect_SelectExtract.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
class TCollection_HAsciiString;
class Standard_Transient;
class Interface_InterfaceModel;
class TCollection_AsciiString;


//! Selects Entities which have a given name. <br>
//!           Consider Property Name if present, else Short Label, but <br>
//!           not the Subscript Number <br>
//!           First version : keeps exact name <br>
//!           Later : regular expression <br>
class IGESSelect_SelectName : public IFSelect_SelectExtract {

public:
 // Methods PUBLIC
 // 

//! Creates an empty SelectName : every entity is considered <br>
//!           good (no filter active) <br>
Standard_EXPORT IGESSelect_SelectName();

//! Returns True if Name of Entity complies with Name Filter <br>
Standard_EXPORT   Standard_Boolean Sort(const Standard_Integer rank,const Handle(Standard_Transient)& ent,const Handle(Interface_InterfaceModel)& model) const;

//! Sets a Name as a criterium : IGES Entities which have this name <br>
//!           are kept (without regular expression, there should be at most <br>
//!           one). <name> can be regarded as a Text Parameter <br>
Standard_EXPORT   void SetName(const Handle(TCollection_HAsciiString)& name) ;

//! Returns the Name used as Filter <br>
Standard_EXPORT   Handle_TCollection_HAsciiString Name() const;

//! Returns the Selection criterium : "IGES Entity, Name : <name>" <br>
Standard_EXPORT   TCollection_AsciiString ExtractLabel() const;
//Standard_EXPORT ~IGESSelect_SelectName();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TCollection_HAsciiString thename;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
