// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESDefs_UnitsData_HeaderFile
#define _IGESDefs_UnitsData_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESDefs_UnitsData_HeaderFile
#include <Handle_IGESDefs_UnitsData.hxx>
#endif

#ifndef _Handle_Interface_HArray1OfHAsciiString_HeaderFile
#include <Handle_Interface_HArray1OfHAsciiString.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Interface_HArray1OfHAsciiString;
class TColStd_HArray1OfReal;
class Standard_DimensionMismatch;
class Standard_OutOfRange;
class TCollection_HAsciiString;


//! defines IGES UnitsData Entity, Type <316> Form <0> <br>
//!          in package IGESDefs <br>
//!          This class stores data about a model's fundamental units. <br>
class IGESDefs_UnitsData : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESDefs_UnitsData();

//! This method is used to set the fields of the class <br>
//!           UnitsData <br>
//!       - unitTypes  : Types of the units being defined <br>
//!       - unitValues : Unit Values of the units <br>
//!       - unitScales : Multiplicative Scale Factors <br>
//! raises exception if lengths of unitTypes, unitValues and <br>
//! unitScale are not same <br>
Standard_EXPORT   void Init(const Handle(Interface_HArray1OfHAsciiString)& unitTypes,const Handle(Interface_HArray1OfHAsciiString)& unitValues,const Handle(TColStd_HArray1OfReal)& unitScales) ;

//! returns the Number of units defined by this entity <br>
Standard_EXPORT   Standard_Integer NbUnits() const;

//! returns the Type of the UnitNum'th unit being defined <br>
//! raises exception if UnitNum <= 0 or UnitNum > NbUnits() <br>
Standard_EXPORT   Handle_TCollection_HAsciiString UnitType(const Standard_Integer UnitNum) const;

//! returns the Units of the UnitNum'th unit being defined <br>
//! raises exception if UnitNum <= 0 or UnitNum > NbUnits() <br>
Standard_EXPORT   Handle_TCollection_HAsciiString UnitValue(const Standard_Integer UnitNum) const;

//! returns the multiplicative scale factor to be apllied to the <br>
//! UnitNum'th unit being defined <br>
//! raises exception if UnitNum <= 0 or UnitNum > NbUnits() <br>
Standard_EXPORT   Standard_Real ScaleFactor(const Standard_Integer UnitNum) const;
//Standard_EXPORT ~IGESDefs_UnitsData();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Interface_HArray1OfHAsciiString theUnitTypes;
Handle_Interface_HArray1OfHAsciiString theUnitValues;
Handle_TColStd_HArray1OfReal theUnitScales;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
