// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFSelect_Transformer_HeaderFile
#define _IFSelect_Transformer_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IFSelect_Transformer_HeaderFile
#include <Handle_IFSelect_Transformer.hxx>
#endif

#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Interface_Protocol_HeaderFile
#include <Handle_Interface_Protocol.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
class Interface_Graph;
class Interface_Protocol;
class Interface_CheckIterator;
class Interface_InterfaceModel;
class Standard_Transient;
class TCollection_AsciiString;


//! A Transformer defines the way an InterfaceModel is transformed <br>
//!           (without sending it to a file). <br>
//!           In order to work, each type of Transformer defines it method <br>
//!           Perform, it can be parametred as needed. <br>
//! <br>
//!           It receives a Model (the data set) as input. It then can : <br>
//!           - edit this Model on the spot (i.e. alter its content : by <br>
//!             editing entities, or adding/replacing some ...) <br>
//!           - produce a copied Model, which detains the needed changes <br>
//!             (typically on the same type, but some or all entities beeing <br>
//!              rebuilt or converted; or converted from a protocol to <br>
//!              another one) <br>
class IFSelect_Transformer : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Performs a Transformation (defined by each sub-class) : <br>
//!         <G> gives the input data (especially the starting model) and <br>
//!           can be used for queries (by Selections, etc...) <br>
//!         <protocol> allows to work with General Services as necessary <br>
//!           (it applies to input data) <br>
//!           If the change corresponds to a conversion to a new protocol, <br>
//!           see also the method ChangeProtocol <br>
//!         <checks> stores produced checks messages if any <br>
//!         <newmod> gives the result of the transformation : <br>
//!         - if it is Null (i.e. has not been affected), the transformation <br>
//!           has been made on the spot, it is assumed to cause no change <br>
//!           to the graph of dependances <br>
//!         - if it equates the starting Model, it has been transformed on <br>
//!           the spot (possibiliy some entities were replaced inside it) <br>
//!         - if it is new, it corresponds to a new data set which replaces <br>
//!           the starting one <br>
//! <br>
//!         <me> is mutable to allow results for ChangeProtocol to be <br>
//!           memorized if needed, and to store informations useful for <br>
//!           the method Updated <br>
//! <br>
//!         Returns True if Done, False if an Error occured : in this case, <br>
//!           if a new data set has been produced, the transformation <br>
//!           is ignored, else data may be corrupted. <br>
Standard_EXPORT virtual  Standard_Boolean Perform(const Interface_Graph& G,const Handle(Interface_Protocol)& protocol,Interface_CheckIterator& checks,Handle(Interface_InterfaceModel)& newmod)  = 0;

//! This methods allows to declare that the Protocol applied to <br>
//!           the new Model has changed. It applies to the last call to <br>
//!           Perform. <br>
//! <br>
//!           Returns True if the Protocol has changed, False else. <br>
//!           The provided default keeps the starting Protocol. This method <br>
//!           should be redefined as required by the effect of Perform. <br>
Standard_EXPORT virtual  Standard_Boolean ChangeProtocol(Handle(Interface_Protocol)& newproto) const;

//! This method allows to know what happened to a starting <br>
//!           entity after the last Perform. If <entfrom> (from starting <br>
//!           model) has one and only one known item which corresponds in <br>
//!           the new produced model, this method must return True and <br>
//!           fill the argument <entto>. Else, it returns False. <br>
Standard_EXPORT virtual  Standard_Boolean Updated(const Handle(Standard_Transient)& entfrom,Handle(Standard_Transient)& entto) const = 0;

//! Returns a text which defines the way a Transformer works <br>
//!           (to identify the transformation it performs) <br>
Standard_EXPORT virtual  TCollection_AsciiString Label() const = 0;
//Standard_EXPORT ~IFSelect_Transformer();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
