// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFSelect_SelectExtract_HeaderFile
#define _IFSelect_SelectExtract_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IFSelect_SelectExtract_HeaderFile
#include <Handle_IFSelect_SelectExtract.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _IFSelect_SelectDeduct_HeaderFile
#include <IFSelect_SelectDeduct.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
class Interface_EntityIterator;
class Interface_Graph;
class Standard_Transient;
class Interface_InterfaceModel;
class TCollection_AsciiString;


//! A SelectExtract determines a list of Entities from an Input <br>
//!           Selection, as a sub-list of the Input Result <br>
//!           It works by applying a sort criterium on each Entity of the <br>
//!           Input. This criterium can be applied Direct to Pick Items <br>
//!           (default case) or Reverse to Remove Item <br>
//! <br>
//!           Basic features (the unique Input) are inherited from SelectDeduct <br>
class IFSelect_SelectExtract : public IFSelect_SelectDeduct {

public:
 // Methods PUBLIC
 // 

//! Returns True if Sort criterium is Direct, False if Reverse <br>
Standard_EXPORT   Standard_Boolean IsDirect() const;

//! Sets Sort criterium sense to a new value <br>
//!           (True : Direct , False : Reverse) <br>
Standard_EXPORT   void SetDirect(const Standard_Boolean direct) ;

//! Returns the list of selected entities. Works by calling the <br>
//!           method Sort on each input Entity : the Entity is kept as <br>
//!           output if Sort returns the same value as Direct status <br>
Standard_EXPORT virtual  Interface_EntityIterator RootResult(const Interface_Graph& G) const;

//! Returns True for an Entity if it satisfies the Sort criterium <br>
//!           It receives : <br>
//!           - <rank>, the rank of the Entity in the Iteration, <br>
//!           - <ent> , the Entity itself, and <br>
//!           - <model>, the Starting Model <br>
//!             Hence, the Entity to check is "model->Value(num)" (but an <br>
//!             InterfaceModel allows other checks) <br>
//!           This method is specific to each class of SelectExtract <br>
Standard_EXPORT virtual  Standard_Boolean Sort(const Standard_Integer rank,const Handle(Standard_Transient)& ent,const Handle(Interface_InterfaceModel)& model) const = 0;

//! Works as Sort but works on the Graph <br>
//!           Default directly calls Sort, but it can be redefined <br>
//!           If SortInGraph is redefined, Sort should be defined even if <br>
//!           not called (to avoid deferred methods in a final class) <br>
Standard_EXPORT virtual  Standard_Boolean SortInGraph(const Standard_Integer rank,const Handle(Standard_Transient)& ent,const Interface_Graph& G) const;

//! Returns a text saying "Picked" or "Removed", plus the <br>
//!           specific criterium returned by ExtractLabel (see below) <br>
Standard_EXPORT   TCollection_AsciiString Label() const;

//! Returns a text defining the criterium for extraction <br>
Standard_EXPORT virtual  TCollection_AsciiString ExtractLabel() const = 0;
//Standard_EXPORT ~IFSelect_SelectExtract();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Initializes a SelectExtract : enforces the sort to be Direct <br>
Standard_EXPORT IFSelect_SelectExtract();


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean thesort;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
