// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomAPI_PointsToBSplineSurface_HeaderFile
#define _GeomAPI_PointsToBSplineSurface_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom_BSplineSurface_HeaderFile
#include <Handle_Geom_BSplineSurface.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Geom_BSplineSurface;
class StdFail_NotDone;
class TColgp_Array2OfPnt;
class TColStd_Array2OfReal;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class is used to approximate or interpolate <br>
//!          a BSplineSurface passing through an  Array2 of <br>
//!          points, with a given continuity. <br>
//! Describes functions for building a BSpline <br>
//! surface which approximates or interpolates a set of points. <br>
//! A PointsToBSplineSurface object provides a framework for: <br>
//! -   defining the data of the BSpline surface to be built, <br>
//! -   implementing the approximation algorithm <br>
//!   or the interpolation algorithm, and consulting the results. <br>
class GeomAPI_PointsToBSplineSurface  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs an empty algorithm for <br>
//! approximation or interpolation of a surface. <br>
//! Use: <br>
//! -   an Init function to define and build the <br>
//!   BSpline surface by approximation, or <br>
//! -   an Interpolate function to define and build <br>
//!   the BSpline surface by interpolation. <br>
Standard_EXPORT GeomAPI_PointsToBSplineSurface();

//! Approximates  a BSpline  Surface passing  through  an <br>
//!          array of  Points.  The resulting BSpline will  have <br>
//!          the following properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol3D <br>
Standard_EXPORT GeomAPI_PointsToBSplineSurface(const TColgp_Array2OfPnt& Points,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol3D = 1.0e-3);

//! Approximates  a BSpline  Surface passing  through  an <br>
//!          array of  Points. <br>
//! <br>
//!          The points will be constructed as follow: <br>
//!            P(i,j) = gp_Pnt( X0 + (i-1)*dX , <br>
//!                             Y0 + (j-1)*dY , <br>
//!                             ZPoints(i,j)   ) <br>
//! <br>
//!          The resulting BSpline will  have the following <br>
//!          properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol3D <br>
//!          4- the parametrization of the surface will verify: <br>
//!               S->Value( U, V) = gp_Pnt( U, V, Z(U,V) ); <br>
Standard_EXPORT GeomAPI_PointsToBSplineSurface(const TColStd_Array2OfReal& ZPoints,const Standard_Real X0,const Standard_Real dX,const Standard_Real Y0,const Standard_Real dY,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol3D = 1.0e-3);

//! Approximates  a BSpline Surface passing  through  an <br>
//!          array of  Point.  The resulting BSpline will  have <br>
//!          the following properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol3D <br>
Standard_EXPORT   void Init(const TColgp_Array2OfPnt& Points,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol3D = 1.0e-3) ;

//! Interpolates  a BSpline Surface passing  through  an <br>
//!          array of  Point.  The resulting BSpline will  have <br>
//!          the following properties: <br>
//!          1- his degree will be 3. <br>
//!          2- his  continuity will be  C2. <br>
Standard_EXPORT   void Interpolate(const TColgp_Array2OfPnt& Points) ;

//! Approximates  a BSpline  Surface passing  through  an <br>
//!          array of  Points. <br>
//! <br>
//!          The points will be constructed as follow: <br>
//!            P(i,j) = gp_Pnt( X0 + (i-1)*dX , <br>
//!                             Y0 + (j-1)*dY , <br>
//!                             ZPoints(i,j)   ) <br>
//! <br>
//!          The resulting BSpline will  have the following <br>
//!          properties: <br>
//!          1- his degree will be in the range [Degmin,Degmax] <br>
//!          2- his  continuity will be  at  least <Continuity> <br>
//!          3- the distance from the point <Points> to the <br>
//!             BSpline will be lower to Tol3D <br>
//!          4- the parametrization of the surface will verify: <br>
//!               S->Value( U, V) = gp_Pnt( U, V, Z(U,V) ); <br>
Standard_EXPORT   void Init(const TColStd_Array2OfReal& ZPoints,const Standard_Real X0,const Standard_Real dX,const Standard_Real Y0,const Standard_Real dY,const Standard_Integer DegMin = 3,const Standard_Integer DegMax = 8,const GeomAbs_Shape Continuity = GeomAbs_C2,const Standard_Real Tol3D = 1.0e-3) ;

//! Interpolates  a BSpline  Surface passing  through  an <br>
//!          array of  Points. <br>
//! <br>
//!          The points will be constructed as follow: <br>
//!            P(i,j) = gp_Pnt( X0 + (i-1)*dX , <br>
//!                             Y0 + (j-1)*dY , <br>
//!                             ZPoints(i,j)   ) <br>
//! <br>
//!          The resulting BSpline will  have the following <br>
//!          properties: <br>
//!          1- his degree will be 3 <br>
//!          2- his  continuity will be  C2. <br>
//!          4- the parametrization of the surface will verify: <br>
//!               S->Value( U, V) = gp_Pnt( U, V, Z(U,V) ); <br>
Standard_EXPORT   void Interpolate(const TColStd_Array2OfReal& ZPoints,const Standard_Real X0,const Standard_Real dX,const Standard_Real Y0,const Standard_Real dY) ;

//! Returns the approximate BSpline Surface <br>
Standard_EXPORT  const Handle_Geom_BSplineSurface& Surface() const;
Standard_EXPORT operator Handle(Geom_BSplineSurface)() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myIsDone;
Handle_Geom_BSplineSurface mySurface;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
