// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom2dAPI_ExtremaCurveCurve_HeaderFile
#define _Geom2dAPI_ExtremaCurveCurve_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Extrema_ExtCC2d_HeaderFile
#include <Extrema_ExtCC2d.hxx>
#endif
#ifndef _Geom2dAdaptor_Curve_HeaderFile
#include <Geom2dAdaptor_Curve.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Quantity_Parameter_HeaderFile
#include <Quantity_Parameter.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
class Standard_OutOfRange;
class StdFail_NotDone;
class Geom2d_Curve;
class gp_Pnt2d;
class Extrema_ExtCC2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes functions for computing all the extrema <br>
//! between two 2D curves. <br>
//! An ExtremaCurveCurve algorithm minimizes or <br>
//! maximizes the distance between a point on the first <br>
//! curve and a point on the second curve. Thus, it <br>
//! computes the start point and end point of <br>
//! perpendiculars common to the two curves (an <br>
//! intersection point is not an extremum except where <br>
//! the two curves are tangential at this point). <br>
//! Solutions consist of pairs of points, and an extremum <br>
//! is considered to be a segment joining the two points of a solution. <br>
//! An ExtremaCurveCurve object provides a framework for: <br>
//! -   defining the construction of the extrema, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the results. <br>
//! Warning <br>
//! In some cases, the nearest points between two <br>
//! curves do not correspond to one of the computed <br>
//! extrema. Instead, they may be given by: <br>
//! -   a limit point of one curve and one of the following: <br>
//!  -   its orthogonal projection on the other curve, <br>
//!  -   a limit point of the other curve; or <br>
//! -   an intersection point between the two curves. <br>
class Geom2dAPI_ExtremaCurveCurve  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//!  Computes the extrema between <br>
//! -   the portion of the curve C1 limited by the two <br>
//!   points of parameter (U1min,U1max), and <br>
//! -   the portion of the curve C2 limited by the two <br>
//!   points of parameter (U2min,U2max). <br>
//! Warning <br>
//! Use the function NbExtrema to obtain the number <br>
//! of solutions. If this algorithm fails, NbExtrema returns 0. <br>
Standard_EXPORT Geom2dAPI_ExtremaCurveCurve(const Handle(Geom2d_Curve)& C1,const Handle(Geom2d_Curve)& C2,const Quantity_Parameter U1min,const Quantity_Parameter U1max,const Quantity_Parameter U2min,const Quantity_Parameter U2max);

//! Returns the number of extrema computed by this algorithm. <br>
//! Note: if this algorithm fails, NbExtrema returns 0. <br>
Standard_EXPORT   Standard_Integer NbExtrema() const;
Standard_EXPORT operator Standard_Integer() const;

//! Returns the points P1 on the first curve and P2 on <br>
//! the second curve, which are the ends of the <br>
//! extremum of index Index computed by this algorithm. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ <br>
//! 1,NbExtrema ], where NbExtrema is the <br>
//! number of extrema computed by this algorithm. <br>
Standard_EXPORT   void Points(const Standard_Integer Index,gp_Pnt2d& P1,gp_Pnt2d& P2) const;

//! Returns the parameters U1 of the point on the first <br>
//! curve and U2 of the point on the second curve, which <br>
//! are the ends of the extremum of index Index <br>
//! computed by this algorithm. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ <br>
//! 1,NbExtrema ], where NbExtrema is the <br>
//! number of extrema computed by this algorithm. <br>
Standard_EXPORT   void Parameters(const Standard_Integer Index,Quantity_Parameter& U1,Quantity_Parameter& U2) const;

//! Computes the distance between the end points of the <br>
//! extremum of index Index computed by this algorithm. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ <br>
//! 1,NbExtrema ], where NbExtrema is the <br>
//! number of extrema computed by this algorithm. <br>
Standard_EXPORT   Quantity_Length Distance(const Standard_Integer Index) const;

//! Returns the points P1 on the first curve and P2 on <br>
//! the second curve, which are the ends of the shortest <br>
//! extremum computed by this algorithm. <br>
//! Exceptions StdFail_NotDone if this algorithm fails. <br>
Standard_EXPORT   void NearestPoints(gp_Pnt2d& P1,gp_Pnt2d& P2) const;

//! Returns the parameters U1 of the point on the first <br>
//! curve and U2 of the point on the second curve, which <br>
//! are the ends of the shortest extremum computed by this algorithm. <br>
//! Exceptions <br>
//! StdFail_NotDone if this algorithm fails. <br>
Standard_EXPORT   void LowerDistanceParameters(Quantity_Parameter& U1,Quantity_Parameter& U2) const;

//! Computes the distance between the end points of the <br>
//! shortest extremum computed by this algorithm. <br>
//! Exceptions - StdFail_NotDone if this algorithm fails. <br>
Standard_EXPORT   Quantity_Length LowerDistance() const;
Standard_EXPORT operator Standard_Real() const;

 const Extrema_ExtCC2d& Extrema() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myIsDone;
Standard_Integer myIndex;
Extrema_ExtCC2d myExtCC;
Geom2dAdaptor_Curve myC1;
Geom2dAdaptor_Curve myC2;


};


#include <Geom2dAPI_ExtremaCurveCurve.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
