// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GccAna_Circ2dBisec_HeaderFile
#define _GccAna_Circ2dBisec_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _gp_Circ2d_HeaderFile
#include <gp_Circ2d.hxx>
#endif
#ifndef _Handle_GccInt_Bisec_HeaderFile
#include <Handle_GccInt_Bisec.hxx>
#endif
class Standard_OutOfRange;
class StdFail_NotDone;
class gp_Circ2d;
class GccInt_Bisec;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class describes functions for building bisecting curves between two 2D circles. <br>
//! A bisecting curve between two circles is a curve such <br>
//! that each of its points is at the same distance from the <br>
//! two circles. It can be an ellipse, hyperbola, circle or line, <br>
//! depending on the relative position of the two circles. <br>
//! The algorithm computes all the elementary curves which <br>
//! are solutions. There is no solution if the two circles are coincident. <br>
//! A Circ2dBisec object provides a framework for: <br>
//! -   defining the construction of the bisecting curves, <br>
//! -   implementing the construction algorithm, and consulting the result. <br>
class GccAna_Circ2dBisec  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs bisecting curves between the two circles Circ1 and Circ2. <br>
Standard_EXPORT GccAna_Circ2dBisec(const gp_Circ2d& Circ1,const gp_Circ2d& Circ2);

//! This method returns True if the construction algorithm succeeded. <br>
Standard_EXPORT   Standard_Boolean IsDone() const;

//! This method returns the number of solutions. <br>
//!    Raises NotDone if the construction algorithm  didn't succeed. <br>
Standard_EXPORT   Standard_Integer NbSolutions() const;

//! Returns the solution number Index <br>
//! Raises OutOfRange exception if Index is greater than <br>
//!          the number of solutions. <br>
//!          It raises NotDone if the construction algorithm <br>
//!          didn't succeed. <br>
Standard_EXPORT   Handle_GccInt_Bisec ThisSolution(const Standard_Integer Index) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean WellDone;
Standard_Integer NbrSol;
Standard_Integer intersection;
Standard_Boolean sameradius;
gp_Circ2d circle1;
gp_Circ2d circle2;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
