// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GC_MakeEllipse_HeaderFile
#define _GC_MakeEllipse_HeaderFile

#ifndef _Handle_Geom_Ellipse_HeaderFile
#include <Handle_Geom_Ellipse.hxx>
#endif
#ifndef _GC_Root_HeaderFile
#include <GC_Root.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Geom_Ellipse;
class StdFail_NotDone;
class gp_Elips;
class gp_Ax2;
class gp_Pnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!This class implements construction algorithms for an ellipse in <br>
//! 3D space. The result is a Geom_Ellipse ellipse. <br>
//! A MakeEllipse object provides a framework for: <br>
//! -   defining the construction of the ellipse, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the results. In particular, the Value <br>
//!   function returns the constructed ellipse. <br>
class GC_MakeEllipse  : public GC_Root {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//!  Creates an ellipse from a non persistent ellipse E from package gp by its conversion. <br>
Standard_EXPORT GC_MakeEllipse(const gp_Elips& E);

//! Constructs an ellipse with major and minor radii MajorRadius and <br>
//!   MinorRadius, and located in the plane defined by <br>
//!   the "X Axis" and "Y Axis" of the coordinate system A2, where: <br>
//!   -   its center is the origin of A2, and <br>
//!   -   its major axis is the "X Axis" of A2; <br>
//!  Warnings : <br>
//!  The MakeEllipse class does not prevent the <br>
//! construction of an ellipse where MajorRadius is equal to MinorRadius. <br>
//! If an error occurs (that is, when IsDone returns <br>
//! false), the Status function returns: <br>
//! -   gce_InvertRadius if MajorRadius is less than MinorRadius; <br>
//! -   gce_NegativeRadius if MinorRadius is less than 0.0; <br>
//! -   gce_NullAxis if the points S1 and Center are coincident; or <br>
//! -   gce_InvertAxis if: <br>
//!   -   the major radius computed with Center and S1 <br>
//!    is less than the minor radius computed with Center, S1 and S2, or <br>
//!   -   Center, S1 and S2 are collinear. <br>
Standard_EXPORT GC_MakeEllipse(const gp_Ax2& A2,const Standard_Real MajorRadius,const Standard_Real MinorRadius);

//! Constructs an ellipse centered on the point Center, where <br>
//!   -   the plane of the ellipse is defined by Center, S1 and S2, <br>
//!   -   its major axis is defined by Center and S1, <br>
//!   -   its major radius is the distance between Center and S1, and <br>
//!   -   its minor radius is the distance between S2 and the major axis. <br>
Standard_EXPORT GC_MakeEllipse(const gp_Pnt& S1,const gp_Pnt& S2,const gp_Pnt& Center);

//! Returns the constructed ellipse. <br>
//! Exceptions StdFail_NotDone if no ellipse is constructed. <br>
Standard_EXPORT  const Handle_Geom_Ellipse& Value() const;


Standard_EXPORT  const Handle_Geom_Ellipse& Operator() const;
Standard_EXPORT operator Handle_Geom_Ellipse() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom_Ellipse TheEllipse;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
