// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Extrema_ExtElCS_HeaderFile
#define _Extrema_ExtElCS_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Handle_Extrema_HArray1OfPOnCurv_HeaderFile
#include <Handle_Extrema_HArray1OfPOnCurv.hxx>
#endif
#ifndef _Handle_Extrema_HArray1OfPOnSurf_HeaderFile
#include <Handle_Extrema_HArray1OfPOnSurf.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class TColStd_HArray1OfReal;
class Extrema_HArray1OfPOnCurv;
class Extrema_HArray1OfPOnSurf;
class StdFail_InfiniteSolutions;
class StdFail_NotDone;
class Standard_OutOfRange;
class gp_Lin;
class gp_Pln;
class gp_Cylinder;
class gp_Cone;
class gp_Sphere;
class gp_Torus;
class gp_Circ;
class gp_Hypr;
class Extrema_POnCurv;
class Extrema_POnSurf;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! It calculates all the distances between a curve and <br>
//!          a surface. <br>
//!          These distances can be maximum or minimum. <br>
class Extrema_ExtElCS  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Extrema_ExtElCS();

//! Calculates the distances between a line and a <br>
//!          plane. The line can be on the plane or on a parallel <br>
//!          plane. <br>
Standard_EXPORT Extrema_ExtElCS(const gp_Lin& C,const gp_Pln& S);


Standard_EXPORT   void Perform(const gp_Lin& C,const gp_Pln& S) ;

//! Calculates the distances between a line and a <br>
//!          cylinder. <br>
Standard_EXPORT Extrema_ExtElCS(const gp_Lin& C,const gp_Cylinder& S);


Standard_EXPORT   void Perform(const gp_Lin& C,const gp_Cylinder& S) ;

//! Calculates the distances between a line and a cone. <br>
Standard_EXPORT Extrema_ExtElCS(const gp_Lin& C,const gp_Cone& S);


Standard_EXPORT   void Perform(const gp_Lin& C,const gp_Cone& S) ;

//! Calculates the distances between a line and a <br>
//!          sphere. <br>
Standard_EXPORT Extrema_ExtElCS(const gp_Lin& C,const gp_Sphere& S);


Standard_EXPORT   void Perform(const gp_Lin& C,const gp_Sphere& S) ;

//! Calculates the distances between a line and a <br>
//!          torus. <br>
Standard_EXPORT Extrema_ExtElCS(const gp_Lin& C,const gp_Torus& S);


Standard_EXPORT   void Perform(const gp_Lin& C,const gp_Torus& S) ;

//! Calculates the distances between a circle and a <br>
//!          plane. <br>
Standard_EXPORT Extrema_ExtElCS(const gp_Circ& C,const gp_Pln& S);


Standard_EXPORT   void Perform(const gp_Circ& C,const gp_Pln& S) ;

//! Calculates the distances between a circle and a <br>
//!          cylinder. <br>
Standard_EXPORT Extrema_ExtElCS(const gp_Circ& C,const gp_Cylinder& S);


Standard_EXPORT   void Perform(const gp_Circ& C,const gp_Cylinder& S) ;

//! Calculates the distances between a circle and a <br>
//!          cone. <br>
Standard_EXPORT Extrema_ExtElCS(const gp_Circ& C,const gp_Cone& S);


Standard_EXPORT   void Perform(const gp_Circ& C,const gp_Cone& S) ;

//! Calculates the distances between a circle and a <br>
//!          sphere. <br>
Standard_EXPORT Extrema_ExtElCS(const gp_Circ& C,const gp_Sphere& S);


Standard_EXPORT   void Perform(const gp_Circ& C,const gp_Sphere& S) ;

//! Calculates the distances between a circle and a <br>
//!          torus. <br>
Standard_EXPORT Extrema_ExtElCS(const gp_Circ& C,const gp_Torus& S);


Standard_EXPORT   void Perform(const gp_Circ& C,const gp_Torus& S) ;

//! Calculates the distances between a hyperbola and a <br>
//!          plane. <br>
Standard_EXPORT Extrema_ExtElCS(const gp_Hypr& C,const gp_Pln& S);


Standard_EXPORT   void Perform(const gp_Hypr& C,const gp_Pln& S) ;

//! Returns True if the distances are found. <br>
Standard_EXPORT   Standard_Boolean IsDone() const;

//! Returns True if the curve is on a parallel surface. <br>
Standard_EXPORT   Standard_Boolean IsParallel() const;

//! Returns the number of extremum distances. <br>
Standard_EXPORT   Standard_Integer NbExt() const;

//! Returns the value of the Nth extremum distance. <br>
Standard_EXPORT   Standard_Real Value(const Standard_Integer N = 1) const;

//! Returns the points of the Nth extremum distance. <br>
//!          P1 is on the curve, P2 on the surface. <br>
Standard_EXPORT   void Points(const Standard_Integer N,Extrema_POnCurv& P1,Extrema_POnSurf& P2) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myDone;
Standard_Integer myNbExt;
Standard_Boolean myIsPar;
Handle_TColStd_HArray1OfReal myValue;
Handle_Extrema_HArray1OfPOnCurv myPoint1;
Handle_Extrema_HArray1OfPOnSurf myPoint2;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
