// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Expr_FunctionDerivative_HeaderFile
#define _Expr_FunctionDerivative_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Expr_FunctionDerivative_HeaderFile
#include <Handle_Expr_FunctionDerivative.hxx>
#endif

#ifndef _Handle_Expr_GeneralFunction_HeaderFile
#include <Handle_Expr_GeneralFunction.hxx>
#endif
#ifndef _Handle_Expr_GeneralExpression_HeaderFile
#include <Handle_Expr_GeneralExpression.hxx>
#endif
#ifndef _Handle_Expr_NamedUnknown_HeaderFile
#include <Handle_Expr_NamedUnknown.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Expr_GeneralFunction_HeaderFile
#include <Expr_GeneralFunction.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Expr_GeneralFunction;
class Expr_GeneralExpression;
class Expr_NamedUnknown;
class Standard_OutOfRange;
class Standard_DimensionMismatch;
class Standard_NumericError;
class Expr_NotEvaluable;
class Expr_NamedFunction;
class Expr_Array1OfNamedUnknown;
class TColStd_Array1OfReal;
class TCollection_AsciiString;



class Expr_FunctionDerivative : public Expr_GeneralFunction {

public:
 // Methods PUBLIC
 // 

//! Creates a FunctionDerivative of degree <deg> relative <br>
//!          to the <withX> variable. <br>
//!          Raises OutOfRange if <deg> lower or equal to zero. <br>
Standard_EXPORT Expr_FunctionDerivative(const Handle(Expr_GeneralFunction)& func,const Handle(Expr_NamedUnknown)& withX,const Standard_Integer deg);

//! Returns the number of variables of <me>. <br>
Standard_EXPORT   Standard_Integer NbOfVariables() const;

//! Returns the variable denoted by <index> in <me>. <br>
//!          Raises OutOfRange if <index> greater than <br>
//!          NbOfVariables of <me>. <br>
Standard_EXPORT   Handle_Expr_NamedUnknown Variable(const Standard_Integer index) const;

//! Computes the value of <me> with the given variables. <br>
//!          Raises DimensionMismatch if Length(vars) is different from <br>
//!          Length(values). <br>
Standard_EXPORT   Standard_Real Evaluate(const Expr_Array1OfNamedUnknown& vars,const TColStd_Array1OfReal& values) const;

//! Returns a copy of <me> with the same form. <br>
Standard_EXPORT   Handle_Expr_GeneralFunction Copy() const;

//! Returns Derivative of <me> for variable <var>. <br>
Standard_EXPORT   Handle_Expr_GeneralFunction Derivative(const Handle(Expr_NamedUnknown)& var) const;

//! Returns Derivative of <me> for variable <var> with <br>
//!          degree <deg>. <br>
Standard_EXPORT   Handle_Expr_GeneralFunction Derivative(const Handle(Expr_NamedUnknown)& var,const Standard_Integer deg) const;

//! Tests if <me> and <func> are similar functions (same <br>
//!          name and same used expression). <br>
Standard_EXPORT   Standard_Boolean IsIdentical(const Handle(Expr_GeneralFunction)& func) const;

//! Tests if <me> is linear on variable on range <index> <br>
Standard_EXPORT   Standard_Boolean IsLinearOnVariable(const Standard_Integer index) const;

//! Returns the function of which <me> is the derivative. <br>
Standard_EXPORT   Handle_Expr_GeneralFunction Function() const;

//! Returns the degree of derivation of <me>. <br>
Standard_EXPORT   Standard_Integer Degree() const;

//! Returns the derivation variable of <me>. <br>
Standard_EXPORT   Handle_Expr_NamedUnknown DerivVariable() const;


Standard_EXPORT   TCollection_AsciiString GetStringName() const;


Standard_EXPORT   Handle_Expr_GeneralExpression Expression() const;


Standard_EXPORT   void UpdateExpression() ;
//Standard_EXPORT ~Expr_FunctionDerivative();


friend class Expr_NamedFunction;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Expr_GeneralFunction myFunction;
Handle_Expr_GeneralExpression myExp;
Handle_Expr_NamedUnknown myDerivate;
Standard_Integer myDegree;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
