// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _CDF_Directory_HeaderFile
#define _CDF_Directory_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_CDF_Directory_HeaderFile
#include <Handle_CDF_Directory.hxx>
#endif

#ifndef _CDM_ListOfDocument_HeaderFile
#include <CDM_ListOfDocument.hxx>
#endif
#ifndef _Standard_Transient_HeaderFile
#include <Standard_Transient.hxx>
#endif
#ifndef _Handle_CDM_Document_HeaderFile
#include <Handle_CDM_Document.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_NoSuchObject;
class CDF_DirectoryIterator;
class CDM_Document;
class CDM_ListOfDocument;


//! A directory is a collection of documents. There is only one instance <br>
//!          of a given document in a directory. <br>
//!          put. <br>
class CDF_Directory : public Standard_Transient {

public:
 // Methods PUBLIC
 // 

//! Creates an empty directory. <br>
Standard_EXPORT CDF_Directory();

//! adds a document into the directory. <br>
Standard_EXPORT   void Add(const Handle(CDM_Document)& aDocument) ;

//! removes the document. <br>
Standard_EXPORT   void Remove(const Handle(CDM_Document)& aDocument) ;

//! Returns true if the document aDocument is in the directory <br>
Standard_EXPORT   Standard_Boolean Contains(const Handle(CDM_Document)& aDocument) const;

//! returns the last document (if any) which has been added <br>
//!          in the directory. <br>
Standard_EXPORT   Handle_CDM_Document Last() ;

//! returns the number of documents of the directory. <br>
Standard_EXPORT   Standard_Integer Length() const;

//! returns true if the directory is empty. <br>
Standard_EXPORT   Standard_Boolean IsEmpty() const;
//Standard_EXPORT ~CDF_Directory();


friend class CDF_DirectoryIterator;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT  const CDM_ListOfDocument& List() const;


 // Fields PRIVATE
 //
CDM_ListOfDocument myDocuments;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
