// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _CDF_Application_HeaderFile
#define _CDF_Application_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_CDF_Application_HeaderFile
#include <Handle_CDF_Application.hxx>
#endif

#ifndef _TCollection_ExtendedString_HeaderFile
#include <TCollection_ExtendedString.hxx>
#endif
#ifndef _CDF_RetrievableStatus_HeaderFile
#include <CDF_RetrievableStatus.hxx>
#endif
#ifndef _CDM_Application_HeaderFile
#include <CDM_Application.hxx>
#endif
#ifndef _Handle_CDM_Document_HeaderFile
#include <Handle_CDM_Document.hxx>
#endif
#ifndef _CDM_CanCloseStatus_HeaderFile
#include <CDM_CanCloseStatus.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _CDF_TypeOfActivation_HeaderFile
#include <CDF_TypeOfActivation.hxx>
#endif
#ifndef _Handle_PCDM_Reader_HeaderFile
#include <Handle_PCDM_Reader.hxx>
#endif
#ifndef _Standard_ExtString_HeaderFile
#include <Standard_ExtString.hxx>
#endif
#ifndef _Handle_CDM_MetaData_HeaderFile
#include <Handle_CDM_MetaData.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_NoSuchObject;
class CDF_Session;
class Standard_GUID;
class CDM_Document;
class TCollection_ExtendedString;
class TColStd_SequenceOfExtendedString;
class PCDM_Reader;
class CDM_MetaData;



class CDF_Application : public CDM_Application {

public:
 // Methods PUBLIC
 // 

//! plugs an application. <br>
//! Open is used <br>
//!       - for opening a Document that has been created in an application <br>
//!       - for opening a Document from the database <br>
//!       - for opening a Document from a file. <br>
//!  The Open methods always add the document in the session directory and <br>
//!  calls the virtual Activate method. The document is considered to be <br>
//!  opened until Close is used. To be storable, a document must be <br>
//!  opened by an application since the application resources are <br>
//!  needed to store it. <br>
//! <br>
//! <br>
//! <br>
//! <br>
Standard_EXPORT static  Handle_CDF_Application Load(const Standard_GUID& aGUID) ;

//! puts the document in the current session directory <br>
//!          and calls the virtual method Activate on it. <br>
Standard_EXPORT   void Open(const Handle(CDM_Document)& aDocument) ;


Standard_EXPORT   CDM_CanCloseStatus CanClose(const Handle(CDM_Document)& aDocument) ;

//! removes the document of the current session directory <br>
//!          and closes the document; <br>
Standard_EXPORT   void Close(const Handle(CDM_Document)& aDocument) ;

//! This method retrieves a document from the database. <br>
//!          If the Document references other documents which have <br>
//!          been updated, the latest version of these documents will <br>
//!          be used if {UseStorageConfiguration} is Standard_True. <br>
//!           The content of {aFolder}, {aName} and {aVersion} depends on <br>
//!           the Database Manager system. If the DBMS is only based on <br>
//!           the OS, {aFolder} is a directory and {aName} is the name of a <br>
//!           file. In this case the use of the syntax with {aVersion} <br>
//!           has no sense. For example: <br>
Standard_EXPORT   Handle_CDM_Document Retrieve(const TCollection_ExtendedString& aFolder,const TCollection_ExtendedString& aName,const Standard_Boolean UseStorageConfiguration = Standard_True) ;

//!  This method retrieves  a  document from the database. <br>
//!          If the  Document references other documents which have <br>
//!          been  updated, the  latest version of  these documents <br>
//!           will    be   used  if   {UseStorageConfiguration}  is <br>
//!          Standard_True.  --  If the DBMS is  only  based on the <br>
//!           OS, this syntax  should not be used. <br>
//! <br>
//!              If the DBMS is EUCLID/Design Manager, {aFolder}, {aName} <br>
//!              and  {aVersion} have the form they have in <br>
//!              EUCLID/Design Manager. For example: <br>
//! <br>
//! Handle(CDM_Document) theDocument=myApplication->Retrieve("|user|cascade","box","2"); <br>
//!             A link is kept with the database through an instance <br>
//!             of CDM_MetaData <br>
Standard_EXPORT   Handle_CDM_Document Retrieve(const TCollection_ExtendedString& aFolder,const TCollection_ExtendedString& aName,const TCollection_ExtendedString& aVersion,const Standard_Boolean UseStorageConfiguration = Standard_True) ;


Standard_EXPORT   CDF_RetrievableStatus CanRetrieve(const TCollection_ExtendedString& aFolder,const TCollection_ExtendedString& aName) ;


Standard_EXPORT   CDF_RetrievableStatus CanRetrieve(const TCollection_ExtendedString& aFolder,const TCollection_ExtendedString& aName,const TCollection_ExtendedString& aVersion) ;


Standard_EXPORT virtual  void Formats(TColStd_SequenceOfExtendedString& Formats)  = 0;
//! Checks  status  after  Retrieve <br>
  CDF_RetrievableStatus GetRetrieveStatus() const;


Standard_EXPORT   Standard_Boolean FindReader(const TCollection_ExtendedString& aFileName) ;


Standard_EXPORT   Handle_PCDM_Reader Reader(const TCollection_ExtendedString& aFileName) ;


Standard_EXPORT   Standard_Boolean FindReaderFromFormat(const TCollection_ExtendedString& aFormat) ;


Standard_EXPORT   Handle_PCDM_Reader ReaderFromFormat(const TCollection_ExtendedString& aFormat) ;

//! try to  retrieve a Format  directly in the  file or in <br>
//!           application   resource  by using   extension. returns <br>
//!          True if found; <br>
Standard_EXPORT   Standard_Boolean Format(const TCollection_ExtendedString& aFileName,TCollection_ExtendedString& theFormat) ;


Standard_EXPORT   Standard_ExtString DefaultFolder() ;


Standard_EXPORT   Standard_Boolean SetDefaultFolder(const Standard_ExtString aFolder) ;


Standard_EXPORT   Standard_ExtString DefaultExtension() ;
//Standard_EXPORT ~CDF_Application();


friend class CDF_Session;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


Standard_EXPORT CDF_Application();


 // Fields PROTECTED
 //
CDF_RetrievableStatus myRetrievableStatus;


private: 

 // Methods PRIVATE
 // 

//! Informs the  application that aDocument has  been <br>
//!          activated. A document is activated when it is created or <br>
//!          retrieved. <br>
//!    aTypeOfActivation will be: <br>
//!            - CDF_TOA_New if the document is a new one <br>
//!              (even empty or retrieved from the database for <br>
//!              the first time). <br>
//!            - CDF_TOA_Unchanged if the document was already <br>
//!              retrieved but had no changes since the previous retrieval. <br>
//!            - CDF_TOA_Modified if the document was already <br>
//!              retrieved and modified since the previous retrieval. <br>
//!  You do not need to call <Activate>, but you should  redefine <br>
//!  this method to implement application specific behavior. <br>
Standard_EXPORT virtual  void Activate(const Handle(CDM_Document)& aDocument,const CDF_TypeOfActivation aTypeOfActivation) ;


Standard_EXPORT   Handle_CDM_Document Retrieve(const Handle(CDM_MetaData)& aMetaData,const Standard_Boolean UseStorageConfiguration) ;


Standard_EXPORT   Handle_CDM_Document Retrieve(const Handle(CDM_MetaData)& aMetaData,const Standard_Boolean UseStorageConfiguration,const Standard_Boolean IsComponent) ;


Standard_EXPORT   Standard_Integer DocumentVersion(const Handle(CDM_MetaData)& theMetaData) ;


Standard_EXPORT   Standard_Boolean FindReader(const TCollection_ExtendedString& aFileName,Standard_GUID& PluginIn,TCollection_ExtendedString& ResourceName) ;


Standard_EXPORT   Standard_Boolean FindReaderFromFormat(const TCollection_ExtendedString& aFormat,Standard_GUID& PluginIn,TCollection_ExtendedString& ResourceName) ;


Standard_EXPORT   CDF_TypeOfActivation TypeOfActivation(const Handle(CDM_MetaData)& aMetaData) ;


Standard_EXPORT   CDF_RetrievableStatus CanRetrieve(const Handle(CDM_MetaData)& aMetaData) ;


 // Fields PRIVATE
 //
TCollection_ExtendedString myDefaultFolder;


};


#include <CDF_Application.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
