// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepPrim_Revolution_HeaderFile
#define _BRepPrim_Revolution_HeaderFile

#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _BRepPrim_OneAxis_HeaderFile
#include <BRepPrim_OneAxis.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Geom_Curve;
class Geom2d_Curve;
class gp_Ax2;
class TopoDS_Face;
class TopoDS_Edge;
class gp_Pnt2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Implement  the OneAxis algoritm   for a revolution <br>
//!          surface. <br>
class BRepPrim_Revolution  : public BRepPrim_OneAxis {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Create a  revolution body <M>  is the  meridian nd <br>
//!          must   be in the XZ  plane   of <A>. <PM>  is  the <br>
//!          meridian in the XZ plane. <br>
Standard_EXPORT BRepPrim_Revolution(const gp_Ax2& A,const Standard_Real VMin,const Standard_Real VMax,const Handle(Geom_Curve)& M,const Handle(Geom2d_Curve)& PM);

//! The surface normal should be directed  towards the <br>
//!          outside. <br>
Standard_EXPORT virtual  TopoDS_Face MakeEmptyLateralFace() const;

//! Returns  an  edge with  a 3D curve   made from the <br>
//!          meridian  in the XZ  plane rotated by <Ang> around <br>
//!          the Z-axis. Ang may be 0 or myAngle. <br>
Standard_EXPORT virtual  TopoDS_Edge MakeEmptyMeridianEdge(const Standard_Real Ang) const;

//! Returns the meridian point at parameter <V> in the <br>
//!          plane XZ. <br>
Standard_EXPORT virtual  gp_Pnt2d MeridianValue(const Standard_Real V) const;

//! Sets the  parametric urve of  the edge <E>  in the <br>
//!          face <F>   to be  the  2d  representation  of  the <br>
//!          meridian. <br>
Standard_EXPORT virtual  void SetMeridianPCurve(TopoDS_Edge& E,const TopoDS_Face& F) const;





protected:

 // Methods PROTECTED
 // 

//! Create a  revolution   body.  The meridian  is set <br>
//!          later. Reserved for derivated classes. <br>
Standard_EXPORT BRepPrim_Revolution(const gp_Ax2& A,const Standard_Real VMin,const Standard_Real VMax);


Standard_EXPORT   void Meridian(const Handle(Geom_Curve)& M,const Handle(Geom2d_Curve)& PM) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom_Curve myMeridian;
Handle_Geom2d_Curve myPMeridian;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
