// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepBuilderAPI_NurbsConvert_HeaderFile
#define _BRepBuilderAPI_NurbsConvert_HeaderFile

#ifndef _BRepBuilderAPI_ModifyShape_HeaderFile
#include <BRepBuilderAPI_ModifyShape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Conversion of the complete geometry of a shape into <br>
//! NURBS geometry. For example, all curves supporting <br>
//! edges of the basis shape are converted into BSpline <br>
//! curves, and all surfaces supporting its faces are <br>
//! converted into BSpline surfaces. <br>
class BRepBuilderAPI_NurbsConvert  : public BRepBuilderAPI_ModifyShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs a framework for converting the geometry of a <br>
//! shape into NURBS geometry. Use the function Perform <br>
//! to define the shape to convert. <br>
Standard_EXPORT BRepBuilderAPI_NurbsConvert();

//!  Builds a new shape by converting the geometry of the <br>
//! shape S into NURBS geometry. Specifically, all curves <br>
//! supporting edges of S are converted into BSpline <br>
//! curves, and all surfaces supporting its faces are <br>
//! converted into BSpline surfaces. <br>
//! Use the function Shape to access the new shape. <br>
//! Note: the constructed framework can be reused to <br>
//! convert other shapes. You specify these with the <br>
//! function Perform. <br>
Standard_EXPORT BRepBuilderAPI_NurbsConvert(const TopoDS_Shape& S,const Standard_Boolean Copy = Standard_False);

//! Builds a new shape by converting the geometry of the <br>
//! shape S into NURBS geometry. <br>
//! Specifically, all curves supporting edges of S are <br>
//! converted into BSpline curves, and all surfaces <br>
//! supporting its faces are converted into BSpline surfaces. <br>
//! Use the function Shape to access the new shape. <br>
//! Note: this framework can be reused to convert other <br>
//! shapes: you specify them by calling the function Perform again. <br>
Standard_EXPORT   void Perform(const TopoDS_Shape& S,const Standard_Boolean Copy = Standard_False) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
