// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepAlgo_DSAccess_HeaderFile
#define _BRepAlgo_DSAccess_HeaderFile

#ifndef _Handle_TopOpeBRepDS_HDataStructure_HeaderFile
#include <Handle_TopOpeBRepDS_HDataStructure.hxx>
#endif
#ifndef _TopOpeBRep_DSFiller_HeaderFile
#include <TopOpeBRep_DSFiller.hxx>
#endif
#ifndef _Handle_TopOpeBRepBuild_HBuilder_HeaderFile
#include <Handle_TopOpeBRepBuild_HBuilder.hxx>
#endif
#ifndef _Handle_BRepAlgo_EdgeConnector_HeaderFile
#include <Handle_BRepAlgo_EdgeConnector.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopoDS_Wire_HeaderFile
#include <TopoDS_Wire.hxx>
#endif
#ifndef _TColStd_ListOfInteger_HeaderFile
#include <TColStd_ListOfInteger.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
#ifndef _TColStd_SetOfInteger_HeaderFile
#include <TColStd_SetOfInteger.hxx>
#endif
#ifndef _BRepAlgo_CheckStatus_HeaderFile
#include <BRepAlgo_CheckStatus.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TopOpeBRepDS_Kind_HeaderFile
#include <TopOpeBRepDS_Kind.hxx>
#endif
class TopOpeBRepDS_HDataStructure;
class TopOpeBRepBuild_HBuilder;
class BRepAlgo_EdgeConnector;
class BRepAlgo_BooleanOperations;
class TopoDS_Shape;
class TopTools_ListOfShape;
class TopoDS_Vertex;
class TColStd_ListOfInteger;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class BRepAlgo_DSAccess  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepAlgo_DSAccess();

//! Purge la  structure de donne  interne, y compris  les <br>
//!          Shapes de Load(). <br>
Standard_EXPORT   void Init() ;

//! Charge le shape dans la SD. <br>
//! <br>
Standard_EXPORT   void Load(const TopoDS_Shape& S) ;

//! Charge les deux shapes dans la SD sans les intersecter. <br>
Standard_EXPORT   void Load(TopoDS_Shape& S1,TopoDS_Shape& S2) ;

//! Intersecte les deux shapes en entre et charge la SD avec <br>
//!          leur intersection. Clear le TopOpeBRepBuild_HBuilder si <br>
//!          besoin <br>
Standard_EXPORT   void Intersect() ;

//! Intersecte les faces contenues dans les deux shapes donnes <br>
//!          et charge la SD avec. Clear le TopOpeBRepBuild_HBuilder <br>
//!          si besoin <br>
Standard_EXPORT   void Intersect(const TopoDS_Shape& S1,const TopoDS_Shape& S2) ;

//! Cette mthode fait la mme chose que la prcdente, <br>
//!          en plus rapide. Il n'y a pas d'intersection face/face 3D. <br>
//!          Les faces ont le mme support(surface). Pas de test de <br>
//!          tangence (ce qui explique qu'elle soit plus rapide). <br>
//!          Intersecte en 2d les faces tangentes F1 et F2. <br>
Standard_EXPORT   void SameDomain(const TopoDS_Shape& S1,const TopoDS_Shape& S2) ;

//! retourne les compounds d'Edge connexe de section qui <br>
//!          contiennent les sections entre les faces contenu dans <br>
//!          S1 et S2. <br>
//!          return une list de Shape vide si S1 ou S2 ne contiennent <br>
//!          pas de face. <br>
//!          appelle GetSectionEdgeSet() si ce n'est pas dj fait <br>
Standard_EXPORT  const TopTools_ListOfShape& GetSectionEdgeSet(const TopoDS_Shape& S1,const TopoDS_Shape& S2) ;

//! return tous les compounds d'edges connexes de section <br>
//!          contenu dans la DS <br>
Standard_EXPORT  const TopTools_ListOfShape& GetSectionEdgeSet() ;

//! NYI <br>
Standard_EXPORT   Standard_Boolean IsWire(const TopoDS_Shape& Compound) ;

//! NYI <br>
Standard_EXPORT  const TopoDS_Shape& Wire(const TopoDS_Shape& Compound) ;

//! NYI <br>
//!          return le vertex de section qui contient la section <br>
//!          entre la face S1 et l'edge S2 (return un Shape vide <br>
//!          si S1 n'est pas une face ou si S2 n'est pas une edge) <br>
Standard_EXPORT  const TopTools_ListOfShape& SectionVertex(const TopoDS_Shape& S1,const TopoDS_Shape& S2) ;

//! Invalider une ligne de section complte. Ensemble <br>
//!          d'Edge connexes par Vertex. Peut-etre un Wire. Peut <br>
//!          etre un ensemble d'Edge connexe ne formant pas un <br>
//!          Wire standard. <br>
Standard_EXPORT   void SuppressEdgeSet(const TopoDS_Shape& Compound) ;

//!  Modifie une ligne de  section.  <New> -- doit etre un <br>
//!          Ensemble d'Edge connexes  par Vertex.  -- Peut-etre un <br>
//!            Wire.  Peut etre un   ensemble  d'Edge -- connexe ne <br>
//!          formant  pas un -- Wire standard.   <New> doit etre un <br>
//!          sous Ensemble de <Old> <br>
//! <br>
//! <br>
Standard_EXPORT   void ChangeEdgeSet(const TopoDS_Shape& Old,const TopoDS_Shape& New) ;

//! NYI <br>
//!          Invalider un Vertex de section. Le Vertex doit avoir <br>
//!          t reconstruit  partir d'un point. <br>
Standard_EXPORT   void SuppressSectionVertex(const TopoDS_Vertex& V) ;


Standard_EXPORT  const TopoDS_Shape& Merge(const TopAbs_State state1,const TopAbs_State state2) ;


Standard_EXPORT  const TopoDS_Shape& Merge(const TopAbs_State state1) ;

//!  NYI   Propagation  d'un  tat   en partant  du  shape <br>
//!           FromShape = edge ou vertex de section, face ou <br>
//!            Coumpound de section. LoadShape est soit S1, <br>
//!          soit S2  (voir   les mthodes Load).   Propagation    <br>
//!          partir de FromShape, sur les tats <what> de LoadShape. <br>
//!          Return un Wire en 2d, un Shell en 3d. <br>
//!          Specs incompletes, a redefinir pour les typologies <br>
//!          correpsondantes de <FromShape> et du resultat : <br>
//!          exemple :    FromShape        resultat <br>
//!                         vertex           wire (ou edge) <br>
//!                    edge de section       face ( ou shell) <br>
//!                    compound de section   shell <br>
//!                      ...                  ... <br>
Standard_EXPORT  const TopoDS_Shape& Propagate(const TopAbs_State what,const TopoDS_Shape& FromShape,const TopoDS_Shape& LoadShape) ;

//! SectionShape est soit un Vertex de section(NYI), soit <br>
//!          une Edge de section. Propagation  des shapes <br>
//!          de section en partant de SectionShape. <br>
//!          return un Compound de section. <br>
Standard_EXPORT  const TopoDS_Shape& PropagateFromSection(const TopoDS_Shape& SectionShape) ;

//! Returns the list of the descendant shapes of the shape <S>. <br>
Standard_EXPORT  const TopTools_ListOfShape& Modified(const TopoDS_Shape& S) ;

//! Returns the fact that the shape <S> has been deleted or not <br>
//!          by the boolean operation. <br>
Standard_EXPORT   Standard_Boolean IsDeleted(const TopoDS_Shape& S) ;

//! NYI <br>
//!          cohrence de la Structure de donne interne. <br>
Standard_EXPORT   BRepAlgo_CheckStatus Check() ;


Standard_EXPORT  const Handle_TopOpeBRepDS_HDataStructure& DS() const;


Standard_EXPORT   Handle_TopOpeBRepDS_HDataStructure& ChangeDS() ;


Standard_EXPORT  const Handle_TopOpeBRepBuild_HBuilder& Builder() const;


Standard_EXPORT   Handle_TopOpeBRepBuild_HBuilder& ChangeBuilder() ;


friend class BRepAlgo_BooleanOperations;



protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void Suppress(const TopoDS_Shape& Compound,const TopoDS_Shape& KeepComp) ;


Standard_EXPORT   void RemoveEdgeInterferences(const Standard_Integer iF1,const Standard_Integer iF2,const Standard_Integer iCurve) ;


Standard_EXPORT   void RemoveEdgeInterferences(const Standard_Integer iE1,const Standard_Integer iE2,const TopoDS_Shape& SectEdge) ;


Standard_EXPORT   void RemoveFaceInterferences(const Standard_Integer iF1,const Standard_Integer iF2,const Standard_Integer iE1,const Standard_Integer iE2) ;


Standard_EXPORT   void RemoveFaceInterferences(const Standard_Integer iF1,const Standard_Integer iF2,const Standard_Integer iCurve) ;


Standard_EXPORT   void RemoveEdgeInterferencesFromFace(const Standard_Integer iF1,const Standard_Integer iF2,const Standard_Integer ipv1,const TopOpeBRepDS_Kind kind1,const Standard_Integer ipv2,const TopOpeBRepDS_Kind kind2) ;


Standard_EXPORT   void RemoveEdgeFromFace(const Standard_Integer iF,const Standard_Integer iV) ;


Standard_EXPORT   void PntVtxOnCurve(const Standard_Integer iCurve,Standard_Integer& ipv1,TopOpeBRepDS_Kind& ik1,Standard_Integer& ipv2,TopOpeBRepDS_Kind& ik2) ;


Standard_EXPORT   void PntVtxOnSectEdge(const TopoDS_Shape& SectEdge,Standard_Integer& ipv1,TopOpeBRepDS_Kind& ik1,Standard_Integer& ipv2,TopOpeBRepDS_Kind& ik2) ;


Standard_EXPORT   void RemoveEdgeSameDomain(const Standard_Integer iE1,const Standard_Integer iE2) ;


Standard_EXPORT   void RemoveFaceSameDomain(const TopoDS_Shape& C) ;


Standard_EXPORT   TColStd_ListOfInteger& FindGoodFace(const Standard_Integer iE,Standard_Integer& iF1,Standard_Boolean& b) ;


Standard_EXPORT   void RemoveFaceSameDomain(const Standard_Integer iF1,const Standard_Integer iF2) ;


Standard_EXPORT   Standard_Boolean GoodInterf(const TopoDS_Shape& SectEdge,const TopOpeBRepDS_Kind kind,const Standard_Integer iPointVertex) ;


 // Fields PRIVATE
 //
Handle_TopOpeBRepDS_HDataStructure myHDS;
TopOpeBRep_DSFiller myDSFiller;
Handle_TopOpeBRepBuild_HBuilder myHB;
Handle_BRepAlgo_EdgeConnector myEC;
TopoDS_Shape myS1;
TopoDS_Shape myS2;
TopAbs_State myState1;
TopAbs_State myState2;
TopTools_ListOfShape myListOfCompoundOfEdgeConnected;
TopTools_ListOfShape myCurrentList;
Standard_Boolean myRecomputeBuilderIsDone;
Standard_Boolean myGetSectionIsDone;
TopoDS_Shape myResultShape;
TopoDS_Wire myWire;
TopTools_ListOfShape myListOfVertex;
TopTools_ListOfShape myModified;
TopoDS_Shape myEmptyShape;
TopTools_ListOfShape myEmptyListOfShape;
TColStd_ListOfInteger myEmptyListOfInteger;
TopTools_DataMapOfShapeShape myCompoundWireMap;
TColStd_SetOfInteger mySetOfKeepPoint;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
