// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_ShellFaceClassifier_HeaderFile
#define _BOP_ShellFaceClassifier_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _TopoDS_Shell_HeaderFile
#include <TopoDS_Shell.hxx>
#endif
#ifndef _BRep_Builder_HeaderFile
#include <BRep_Builder.hxx>
#endif
#ifndef _BOP_SolidClassifier_HeaderFile
#include <BOP_SolidClassifier.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
#ifndef _BOP_CompositeClassifier_HeaderFile
#include <BOP_CompositeClassifier.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
class BOP_BlockBuilder;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class BOP_ShellFaceClassifier  : public BOP_CompositeClassifier {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Creates a classifier in 3D space, to compare <br>
//! a face with a set of faces, <br>
//! a shell with a set of faces, <br>
//! a shell with a shell <br>
Standard_EXPORT BOP_ShellFaceClassifier(const BOP_BlockBuilder& theBlockBuilder);


//! Clears  contents of internal state of the object <br>
Standard_EXPORT   void Clear() ;


//! Classify shape <B1> with shape <B2> <br>
Standard_EXPORT virtual  TopAbs_State CompareShapes(const TopoDS_Shape& B1,const TopoDS_Shape& B2) ;


//! Classify element <E> with shape <B> <br>
Standard_EXPORT virtual  TopAbs_State CompareElementToShape(const TopoDS_Shape& E,const TopoDS_Shape& B) ;


//! Prepare classification involving shape <B> <br>
//! Calls ResetElement on first element of <B> <br>
Standard_EXPORT virtual  void ResetShape(const TopoDS_Shape& B) ;


//! Prepare classification involving element <E>. <br>
Standard_EXPORT virtual  void ResetElement(const TopoDS_Shape& E) ;


//! Add element <E> in the set of elements used in classification. <br>
Standard_EXPORT   void CompareElement(const TopoDS_Shape& E) ;


//! Returns state of classification of 2D point, defined by <br>
//! ResetElement, with the current set of elements, <br>
//! defined by Compare. <br>
Standard_EXPORT virtual  TopAbs_State State() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myFirstCompare;
gp_Pnt myPoint;
TopoDS_Shell myShell;
BRep_Builder myBuilder;
BOP_SolidClassifier mySolidClassifier;
TopTools_DataMapOfShapeShape myFaceShellMap;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
