// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_ConnexityBlock_HeaderFile
#define _BOP_ConnexityBlock_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
class TopTools_ListOfShape;
class TopTools_IndexedMapOfOrientedShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  Auxiliary class to store data about set <br>
//!  of connex shapes <br>
//! <br>
class BOP_ConnexityBlock  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor; <br>
Standard_EXPORT BOP_ConnexityBlock();


//! Modifier <br>
Standard_EXPORT   void SetShapes(const TopTools_ListOfShape& anEdges) ;


//! Modifier <br>
Standard_EXPORT   void SetShapes(const TopTools_IndexedMapOfOrientedShape& nEdges) ;


//! Modifier <br>
Standard_EXPORT   void SetRegularity(const Standard_Boolean aFlag) ;


//! Selector <br>
Standard_EXPORT  const TopTools_ListOfShape& Shapes() const;


//! Selector <br>
//! Returns TRUE if all elements in the block are <br>
//! biconnexity <br>
Standard_EXPORT   Standard_Boolean IsRegular() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myRegularity;
TopTools_ListOfShape myShapes;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
