// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOPTools_CommonBlock_HeaderFile
#define _BOPTools_CommonBlock_HeaderFile

#ifndef _BOPTools_PaveBlock_HeaderFile
#include <BOPTools_PaveBlock.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class BOPTools_PaveBlock;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  The class hold a structure  for storing info about a couple <br>
//!  of pave blocks that are considered as common <br>
class BOPTools_CommonBlock  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor <br>
Standard_EXPORT BOPTools_CommonBlock();


//! Constructor that uses couple of pave blocks <br>
Standard_EXPORT BOPTools_CommonBlock(const BOPTools_PaveBlock& aPB1,const BOPTools_PaveBlock& aPB2);


//! Constructor that uses a pave block and a face <br>
Standard_EXPORT BOPTools_CommonBlock(const BOPTools_PaveBlock& aPB1,const Standard_Integer aF);


//! Modifier <br>
//! Sets first block <br>
Standard_EXPORT   void SetPaveBlock1(const BOPTools_PaveBlock& aPB1) ;


//! Modifier <br>
//! Sets second block <br>
Standard_EXPORT   void SetPaveBlock2(const BOPTools_PaveBlock& aPB2) ;


//! Modifier <br>
//! Sets DS-index of the face (if it exists) with which the <br>
//! CommonBlock is common. 0 is  default value <br>
Standard_EXPORT   void SetFace(const Standard_Integer aF) ;


//! Selector <br>
//! Always returns first block myPB1 <br>
Standard_EXPORT  const BOPTools_PaveBlock& PaveBlock1() const;


//! Selector <br>
//! Returns block that belongs to the original edge with <br>
//! DS-index=anIndex <br>
Standard_EXPORT   BOPTools_PaveBlock& PaveBlock1(const Standard_Integer anIndex) ;


//! Selector <br>
//! Always returns first block myPB2 <br>
Standard_EXPORT  const BOPTools_PaveBlock& PaveBlock2() const;


//! Selector <br>
//! Returns block that does not belong to the original edge with <br>
//! DS-index=anIndex <br>
Standard_EXPORT   BOPTools_PaveBlock& PaveBlock2(const Standard_Integer anIndex) ;


//! Selector <br>
//! Returns  the DS-index of the face (if exists) <br>
//! with which the CommonBlock is common. <br>
//! Otherwise it returns 0. <br>
Standard_EXPORT   Standard_Integer Face() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BOPTools_PaveBlock myPB1;
BOPTools_PaveBlock myPB2;
Standard_Integer myFace;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
