// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOPTools_Checker_HeaderFile
#define _BOPTools_Checker_HeaderFile

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _BOPTools_ListOfCheckResults_HeaderFile
#include <BOPTools_ListOfCheckResults.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _BOPTools_PaveFiller_HeaderFile
#include <BOPTools_PaveFiller.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
class TopoDS_Shape;
class BOPTools_InterferencePool;
class BOPTools_ListOfCheckResults;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  class that provides the algorithm <br>
//!  to  check a shape on self-interference. <br>
class BOPTools_Checker  : public BOPTools_PaveFiller {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty Contructor <br>
Standard_EXPORT BOPTools_Checker();


//! Contructs the object using the shape <aS> to check <br>
Standard_EXPORT BOPTools_Checker(const TopoDS_Shape& aS);


//! Contructs the object using the <InterferencePool> <br>
Standard_EXPORT BOPTools_Checker(const BOPTools_InterferencePool& aIP);


//! Destructor <br>
Standard_EXPORT virtual  void Destroy() ;
Standard_EXPORT virtual ~BOPTools_Checker(){Destroy();}

//! if <StopOnFirstFaulty == Standard_True> the process stops <br>
//!          and the exception throws; otherwise all faulties are searched <br>
Standard_EXPORT   void SetPerformType(const Standard_Boolean StopOnFirstFaulty) ;


//! Launches  the  algorithm <br>
Standard_EXPORT virtual  void Perform() ;


//! Selector <br>
Standard_EXPORT   void SetShape(const TopoDS_Shape& aS) ;


//! Selector <br>
Standard_EXPORT  const TopoDS_Shape& Shape() const;

//! returnes a result of check <br>
Standard_EXPORT  const BOPTools_ListOfCheckResults& GetCheckResult() const;


//! Selector. <br>
//! Retrns TRUE if there is interferred sub-shapes . <br>
Standard_EXPORT   Standard_Boolean HasFaulty() const;





protected:

 // Methods PROTECTED
 // 


//! See in base classe, please <br>
Standard_EXPORT virtual  void PerformVV() ;


//! See in base classe, please <br>
Standard_EXPORT virtual  void PerformVE() ;


//! See in base classe, please <br>
Standard_EXPORT virtual  void PerformVF() ;


//! See in base classe, please <br>
Standard_EXPORT virtual  void PerformEE() ;


//! See in base classe, please <br>
Standard_EXPORT virtual  void PerformEF() ;


//! See in base classe, please <br>
Standard_EXPORT virtual  void PerformFF() ;


//! Prepare end paves for each edge <br>
Standard_EXPORT virtual  void PrepareEdges() ;


//! Internal usage <br>
Standard_EXPORT virtual  void PreparePaveBlocks(const TopAbs_ShapeEnum aType1,const TopAbs_ShapeEnum aType2) ;


//! Prepare end paves for the edge <anE> <br>
Standard_EXPORT virtual  void PreparePaveBlocks(const Standard_Integer anE) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Shape myShape;
BOPTools_ListOfCheckResults myCheckResults;
Standard_Boolean myStopOnFirst;
Standard_Integer myEntryType;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
