// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Aspect_WidthMapEntry_HeaderFile
#define _Aspect_WidthMapEntry_HeaderFile

#ifndef _Aspect_WidthOfLine_HeaderFile
#include <Aspect_WidthOfLine.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
class Standard_OutOfRange;
class Aspect_BadAccess;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class defines a widthmap entry. <br>
//!	    A widthmap entry is an association between <br>
//!	    a LineStyle object and an index in the widthmap. <br>
class Aspect_WidthMapEntry  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an unallocated widthmap entry <br>
Standard_EXPORT Aspect_WidthMapEntry();

//! Creates an allocated widthmap entry from width style <br>
Standard_EXPORT Aspect_WidthMapEntry(const Standard_Integer index,const Aspect_WidthOfLine style);

//! Creates an allocated widthmap entry from width value <br>
Standard_EXPORT Aspect_WidthMapEntry(const Standard_Integer index,const Quantity_Length width);

//! Creates an allocated widthmap entry. <br>
Standard_EXPORT Aspect_WidthMapEntry(const Aspect_WidthMapEntry& entry);

//! Sets widthmap entry value from width style <br>
//!	    and allocates it. <br>
Standard_EXPORT   void SetValue(const Standard_Integer index,const Aspect_WidthOfLine style) ;

//! Sets widthmap entry value from width value <br>
//!	    and allocates it. <br>
Standard_EXPORT   void SetValue(const Standard_Integer index,const Quantity_Length width) ;

//! Sets widthmap entry value and allocates it. <br>
Standard_EXPORT   void SetValue(const Aspect_WidthMapEntry& entry) ;
  void operator =(const Aspect_WidthMapEntry& entry) 
{
  SetValue(entry);
}


//! Sets index value of a widthmap entry. <br>
Standard_EXPORT   void SetIndex(const Standard_Integer index) ;

//! Sets width style of widthmap entry. <br>
Standard_EXPORT   void SetType(const Aspect_WidthOfLine Style) ;

//! Sets width value of widthmap entry. <br>
Standard_EXPORT   void SetWidth(const Quantity_Length Width) ;


Standard_EXPORT   Aspect_WidthOfLine Type() const;

//! Returns width value of widthmap entry. <br>
//!  Warning: Raises error if the widthmap entry is unallocated . <br>
Standard_EXPORT   Quantity_Length Width() const;

//! Returns index value of a widthmap entry. <br>
//!  Warning: Raises error if the widthmap entry is unallocated . <br>
Standard_EXPORT   Standard_Integer Index() const;

//! Unallocates the widthmap entry. <br>
Standard_EXPORT   void Free() ;

//! Returns True if the widthmap entry is allocated. <br>
//!  Warning: A widthmap entry is allocated when the width and <br>
//!	    the index is defined. <br>
Standard_EXPORT   Standard_Boolean IsAllocated() const;


Standard_EXPORT   void Dump() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Set Line Width with the predefined style values <br>
//!          according of type <br>
//!  Warning: Raises error if the Width style is USER_DEFINED <br>
Standard_EXPORT   void SetPredefinedStyle(const Aspect_WidthOfLine Type) ;


 // Fields PRIVATE
 //
Aspect_WidthOfLine MyType;
Standard_Real MyWidth;
Standard_Integer MyIndex;
Standard_Boolean MyTypeIsDef;
Standard_Boolean MyIndexIsDef;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
