// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Aspect_WidthMap_HeaderFile
#define _Aspect_WidthMap_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Aspect_WidthMap_HeaderFile
#include <Handle_Aspect_WidthMap.hxx>
#endif

#ifndef _Aspect_SequenceOfWidthMapEntry_HeaderFile
#include <Aspect_SequenceOfWidthMapEntry.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Aspect_WidthOfLine_HeaderFile
#include <Aspect_WidthOfLine.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
class Aspect_BadAccess;
class Aspect_WidthMapEntry;


//! This class defines a WidthMap object. <br>
class Aspect_WidthMap : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates a width map. <br>
Standard_EXPORT Aspect_WidthMap();

//! Adds an entry in the Width map <me>. <br>
//!  Warning: Raises BadAccess if WidthMap size is exceeded. <br>
Standard_EXPORT   void AddEntry(const Aspect_WidthMapEntry& AnEntry) ;

//! Search an identical line width entry in the width map <me> <br>
//! and returns the WidthMapEntry Index if exist. <br>
//! Or add a new entry and returns the computed WidthMapEntry index used. <br>
Standard_EXPORT   Standard_Integer AddEntry(const Aspect_WidthOfLine aStyle) ;

//! Search an identical line width entry in the width map <me> <br>
//! and returns the WidthMapEntry Index if exist. <br>
//! Or add a new entry and returns the computed WidthMapEntry index used. <br>
Standard_EXPORT   Standard_Integer AddEntry(const Quantity_Length aStyle) ;

//! Returns the Allocated widthmap Size <br>
Standard_EXPORT   Standard_Integer Size() const;

//! Returns the WidthMapEntry.Index of the WidthMap <br>
//!          at rank <aWidthmapIndex> . <br>
Standard_EXPORT   Standard_Integer Index(const Standard_Integer aWidthmapIndex) const;

//! Returns the Width map entry with the index <AnIndex>. <br>
//!  Warning: Raises BadAccess if the index less than 1 or <br>
//!	    greater than Size. <br>
Standard_EXPORT   Aspect_WidthMapEntry Entry(const Standard_Integer AnIndex) const;


Standard_EXPORT   void Dump() const;
//Standard_EXPORT ~Aspect_WidthMap();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Aspect_SequenceOfWidthMapEntry mydata;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
