/*
 * NVIDIA CUDA Debugger CUDA-GDB Copyright (C) 2007-2017 NVIDIA Corporation
 * Written by CUDA-GDB team at NVIDIA <cudatools@nvidia.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _REMOTE_CUDA_H
#define _REMOTE_CUDA_H 1

#include "target.h"
#ifndef __QNXTARGET__
#include "remote.h"
#endif /* __QNXTARGET__ */

extern void cuda_sigtrap_set_silent (void);
extern void cuda_sigtrap_restore_settings (void);
extern void cuda_print_memcheck_message (void);
extern void cuda_print_assert_message (void);

void cuda_remote_add_target (struct target_ops *t);
void set_cuda_remote_flag (bool connected);
#ifdef __QNXTARGET__
void cuda_version_handshake (const char *version_string);
void cuda_finalize_remote_target (void);
#else /* __QNXTARGET__ */
void cuda_remote_version_handshake (const struct protocol_feature *feature,
                                    enum packet_support support,
                                    const char *version_string);
#endif /* __QNXTARGET__ */
#endif
