/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.internal.corext.codemanipulation.IncludeInfo;
import org.eclipse.cdt.internal.ui.refactoring.includes.HeaderSubstitutionMap;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeCreationContext;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeMap;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeUtil;
import org.eclipse.cdt.internal.ui.refactoring.includes.InclusionRequest;
import org.eclipse.cdt.internal.ui.refactoring.includes.SymbolExportMap;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;

public class HeaderSubstitutor {
    private final IncludeCreationContext fContext;
    private IncludeMap[] fIncludeMaps;
    private SymbolExportMap fSymbolExportMap;

    public HeaderSubstitutor(IncludeCreationContext context) {
        List<Object> maps;
        this.fContext = context;
        this.fIncludeMaps = new IncludeMap[]{new IncludeMap(true), new IncludeMap(false)};
        IPreferencesService preferences = Platform.getPreferencesService();
        IScopeContext[] scopes = PreferenceConstants.getPreferenceScopes(context.getProject());
        String str = preferences.getString("org.eclipse.cdt.ui", "organizeIncludes.headerSubstitution", null, scopes);
        if (str != null) {
            maps = HeaderSubstitutionMap.deserializeMaps(str);
            for (Object map : maps) {
                if (((HeaderSubstitutionMap)map).isCppOnly() && !this.fContext.isCXXLanguage()) continue;
                this.fIncludeMaps[0].addAllMappings(((HeaderSubstitutionMap)map).getUnconditionalSubstitutionMap());
                this.fIncludeMaps[1].addAllMappings(((HeaderSubstitutionMap)map).getOptionalSubstitutionMap());
            }
        }
        this.addHeaderDerivedMappings();
        this.fIncludeMaps[0].transitivelyClose();
        this.fIncludeMaps[1].transitivelyClose();
        this.fSymbolExportMap = new SymbolExportMap();
        str = preferences.getString("org.eclipse.cdt.ui", "organizeIncludes.symbolExportingHeaders", null, scopes);
        if (str != null) {
            maps = SymbolExportMap.deserializeMaps(str);
            for (Object map : maps) {
                this.fSymbolExportMap.addAllMappings((SymbolExportMap)map);
            }
        }
    }

    private void addHeaderDerivedMappings() {
        try {
            IIndexFile[] iIndexFileArray = this.fContext.getIndex().getAllFiles();
            int n = iIndexFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexFile file = iIndexFileArray[n2];
                String replacement = file.getReplacementHeader();
                if (replacement != null) {
                    IncludeInfo includeInfo;
                    IPath path = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)file.getLocation());
                    if (!this.fContext.getCurrentDirectory().isPrefixOf(path) && (includeInfo = this.fContext.getIncludeForHeaderFile(path)) != null) {
                        IncludeInfo replacementInfo;
                        int n3;
                        int n4;
                        String[] stringArray;
                        if (replacement.isEmpty()) {
                            IIndexInclude[] includedBy = this.fContext.getIndex().findIncludedBy(file, 0);
                            stringArray = includedBy;
                            n4 = includedBy.length;
                            n3 = 0;
                            while (n3 < n4) {
                                String include = stringArray[n3];
                                IPath includer = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)include.getIncludedByLocation());
                                replacementInfo = this.fContext.getIncludeForHeaderFile(includer);
                                if (replacementInfo != null) {
                                    this.fIncludeMaps[0].addMapping(includeInfo, replacementInfo);
                                }
                                ++n3;
                            }
                        } else {
                            String[] headers;
                            stringArray = headers = replacement.split(",");
                            n4 = headers.length;
                            n3 = 0;
                            while (n3 < n4) {
                                String header = stringArray[n3];
                                if (!header.isEmpty()) {
                                    char firstChar = header.charAt(0);
                                    replacementInfo = firstChar == '\"' || firstChar == '<' ? new IncludeInfo(header) : new IncludeInfo(header, includeInfo.isSystem());
                                    this.fIncludeMaps[0].addMapping(includeInfo, replacementInfo);
                                }
                                ++n3;
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    public IPath getUniqueRepresentativeHeader(IPath path) {
        IncludeMap map;
        IncludeMap[] maps;
        IncludeInfo includeInfo = this.fContext.getIncludeForHeaderFile(path);
        if (includeInfo == null) {
            return null;
        }
        IncludeMap[] includeMapArray = maps = this.fIncludeMaps;
        int n = maps.length;
        int n2 = 0;
        while (n2 < n) {
            map = includeMapArray[n2];
            if (map.isUnconditionalSubstitution()) {
                List<IncludeInfo> replacements = map.getMapping(includeInfo);
                if (replacements.size() == 1) {
                    includeInfo = replacements.get(0);
                } else if (replacements.size() > 1) {
                    return null;
                }
            }
            ++n2;
        }
        includeMapArray = maps;
        n = maps.length;
        n2 = 0;
        while (n2 < n) {
            map = includeMapArray[n2];
            if (!map.isUnconditionalSubstitution() && !map.getMapping(includeInfo).isEmpty()) {
                return null;
            }
            ++n2;
        }
        return this.fContext.resolveInclude(includeInfo);
    }

    public IPath getPreferredRepresentativeHeader(IPath path) {
        IncludeInfo includeInfo = this.fContext.getIncludeForHeaderFile(path);
        if (includeInfo == null) {
            return path;
        }
        ArrayList<IncludeInfo> candidates = new ArrayList<IncludeInfo>();
        candidates.add(includeInfo);
        IncludeMap[] maps = this.fIncludeMaps;
        IncludeMap[] includeMapArray = maps;
        int n = maps.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeMap map = includeMapArray[n2];
            int i = 0;
            while (i < candidates.size()) {
                IncludeInfo candidate = (IncludeInfo)candidates.get(i);
                List<IncludeInfo> replacements = map.getMapping(candidate);
                int increment = 1;
                if (!replacements.isEmpty()) {
                    if (map.isUnconditionalSubstitution()) {
                        candidates.remove(i);
                        increment = 0;
                    }
                    candidates.addAll(i, replacements);
                    increment += replacements.size();
                }
                i += increment;
            }
            ++n2;
        }
        IPath firstResolved = null;
        IPath firstIncludedPreviously = null;
        for (IncludeInfo candidate : candidates) {
            IPath header = this.fContext.resolveInclude(candidate);
            if (header == null) continue;
            if (this.fContext.isIncluded(header)) {
                return header;
            }
            if (firstResolved == null) {
                firstResolved = header;
            }
            if (firstIncludedPreviously != null || !this.fContext.wasIncludedPreviously(header)) continue;
            firstIncludedPreviously = header;
        }
        return firstIncludedPreviously != null ? firstIncludedPreviously : (firstResolved != null ? firstResolved : path);
    }

    public IPath getPreferredRepresentativeHeaderByHeuristic(InclusionRequest request) {
        Set<IIndexFile> indexFiles = request.getDeclaringFiles().keySet();
        String symbolName = request.getBinding().getName();
        ArrayDeque<IIndexFile> front = new ArrayDeque<IIndexFile>();
        HashSet<IIndexFile> processed = new HashSet<IIndexFile>();
        try {
            IIndexFile includer;
            IIndexInclude include;
            int n;
            int n2;
            IIndexInclude[] iIndexIncludeArray;
            IIndexInclude[] includes;
            String path;
            IIndexFile file;
            if (this.fContext.isCXXLanguage()) {
                front.addAll(indexFiles);
                processed.addAll(indexFiles);
                while (!front.isEmpty()) {
                    file = (IIndexFile)front.remove();
                    path = IncludeUtil.getPath(file);
                    if (!HeaderSubstitutor.hasExtension(path) && HeaderSubstitutor.getFilename(path).equalsIgnoreCase(symbolName)) {
                        return IndexLocationFactory.getAbsolutePath((IIndexFileLocation)file.getLocation());
                    }
                    iIndexIncludeArray = includes = this.fContext.getIndex().findIncludedBy(file, 0);
                    n2 = includes.length;
                    n = 0;
                    while (n < n2) {
                        include = iIndexIncludeArray[n];
                        includer = include.getIncludedBy();
                        if (!processed.contains(includer)) {
                            front.add(includer);
                            processed.add(includer);
                        }
                        ++n;
                    }
                }
            }
            front.clear();
            front.addAll(indexFiles);
            processed.clear();
            processed.addAll(indexFiles);
            while (!front.isEmpty()) {
                file = (IIndexFile)front.remove();
                path = IncludeUtil.getPath(file);
                if (this.fContext.isCXXLanguage() && !HeaderSubstitutor.hasExtension(path)) {
                    return IndexLocationFactory.getAbsolutePath((IIndexFileLocation)file.getLocation());
                }
                iIndexIncludeArray = includes = this.fContext.getIndex().findIncludedBy(file, 0);
                n2 = includes.length;
                n = 0;
                while (n < n2) {
                    include = iIndexIncludeArray[n];
                    includer = include.getIncludedBy();
                    if (!processed.contains(includer)) {
                        URI uri = includer.getLocation().getURI();
                        if (IncludeUtil.isSource(includer, this.fContext.getProject()) || HeaderSubstitutor.isWorkspaceFile(uri)) {
                            return IndexLocationFactory.getAbsolutePath((IIndexFileLocation)file.getLocation());
                        }
                        front.add(includer);
                        processed.add(includer);
                    }
                    ++n;
                }
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        return request.getCandidatePaths().iterator().next();
    }

    public Set<IncludeInfo> getExportingHeaders(String symbol) {
        Set<IncludeInfo> headers = this.fSymbolExportMap.getMapping(symbol);
        if (headers == null) {
            return Collections.emptySet();
        }
        return headers;
    }

    private static boolean isWorkspaceFile(URI uri) {
        IFile[] iFileArray = ResourceLookup.findFilesForLocationURI((URI)uri);
        int n = iFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (file.exists()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean hasExtension(String path) {
        return path.indexOf(46, path.lastIndexOf(47) + 1) >= 0;
    }

    private static String getFilename(String path) {
        int startPos = path.lastIndexOf(47) + 1;
        int endPos = path.lastIndexOf(46);
        if (endPos > startPos) {
            return path.substring(startPos, endPos);
        }
        return path.substring(startPos);
    }
}

