/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.query;

import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.model.query.Dim3Filter;
import com.nvidia.cuda.ide.debug.model.query.IFilterCondition;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;

public class LogicalWildcardCondition
implements IFilterCondition {
    private final int kernelId;
    private final Dim3Filter block;
    private final Dim3Filter thread;

    public LogicalWildcardCondition(int kernelId, Dim3Filter blockFilter, Dim3Filter threadFilter) {
        this.kernelId = kernelId;
        Dim3Filter dim3Filter = blockFilter == null ? null : (this.block = blockFilter.isAllElements() ? null : blockFilter);
        this.thread = threadFilter == null ? null : (threadFilter.isAllElements() ? null : threadFilter);
    }

    @Override
    public boolean isAllElements() {
        return this.kernelId < 0 && this.block == null && this.thread == null;
    }

    @Override
    public boolean matches(ICudaRuntimeObject o) {
        switch (o.getType()) {
            case thread: {
                return (this.thread == null || this.thread.matches(((DeviceThread)o).getThreadIdx())) && this.matches((ICudaRuntimeObject)DMContexts.getAncestorOfType((IDMContext)o, Block.class));
            }
            case block: {
                return (this.block == null || this.block.matches(((Block)o).getBlockIdx())) && this.matches((ICudaRuntimeObject)DMContexts.getAncestorOfType((IDMContext)o, Kernel.class));
            }
            case kernel: {
                Kernel kernel = (Kernel)o;
                return this.matchKernel(kernel);
            }
        }
        return false;
    }

    private boolean matchKernel(Kernel kernel) {
        CudaCoord[] blocks;
        if (!(this.kernelId >= 0 && (long)this.kernelId != kernel.getId() || (blocks = this.filterBlocks(kernel)) != null && blocks.length == 0)) {
            try {
                CudaCoord[] threads = this.filterThreads(kernel.getBlock(CudaCoord.ZERO));
                return threads == null || threads.length > 0;
            }
            catch (CudaException cudaException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isHardware() {
        return false;
    }

    @Override
    public CudaCoord[] filterBlocks(Kernel kernel) {
        return this.block == null ? null : this.block.getAllCoords(kernel.getGridDim());
    }

    @Override
    public CudaCoord[] filterThreads(Block block) {
        return this.thread == null ? null : this.thread.getAllCoords(((Kernel)DMContexts.getAncestorOfType((IDMContext)block, Kernel.class)).getBlockDim());
    }

    @Override
    public long getEnabledLanes(Warp warp) {
        return Long.MIN_VALUE;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.kernelId >= 0) {
            builder.append("kernel ").append(this.kernelId);
        }
        if (this.block != null && !this.block.isAllElements()) {
            builder.append(" block ").append(this.block);
        }
        if (this.thread != null && !this.thread.isAllElements()) {
            builder.append(" thread ").append(this.thread);
        }
        return "(" + builder.toString().trim() + ")";
    }

    @Override
    public long getEnabledSMs(Device device) {
        return Long.MIN_VALUE;
    }

    @Override
    public long getEnabledWarps(StreamingMultiprocessor sm) {
        return Long.MIN_VALUE;
    }

    @Override
    public ElementType getElementType() {
        if (this.thread != null) {
            return ElementType.thread;
        }
        if (this.block != null) {
            return ElementType.block;
        }
        if (this.kernelId >= 0) {
            return ElementType.kernel;
        }
        return ElementType.application;
    }
}

