/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup.browsers;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.internal.ui.sourcelookup.browsers.FolderSourceContainerDialog;
import org.eclipse.debug.ui.sourcelookup.AbstractSourceContainerBrowser;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FolderSourceContainerBrowser
extends AbstractSourceContainerBrowser {
    @Override
    public ISourceContainer[] addSourceContainers(Shell shell, ISourceLookupDirector director) {
        FolderSourceContainerDialog dialog = new FolderSourceContainerDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        if (dialog.open() == 0) {
            Object[] selection = dialog.getResult();
            ArrayList<FolderSourceContainer> containers = new ArrayList<FolderSourceContainer>();
            int i = 0;
            while (i < selection.length) {
                if (selection[i] instanceof IFolder) {
                    containers.add(new FolderSourceContainer((IContainer)((IFolder)selection[i]), dialog.isSearchSubfolders()));
                }
                ++i;
            }
            return containers.toArray(new ISourceContainer[containers.size()]);
        }
        return new ISourceContainer[0];
    }

    @Override
    public boolean canEditSourceContainers(ISourceLookupDirector director, ISourceContainer[] containers) {
        return containers.length == 1 && containers[0].getType().getId().equals(FolderSourceContainer.TYPE_ID);
    }

    @Override
    public ISourceContainer[] editSourceContainers(Shell shell, ISourceLookupDirector director, ISourceContainer[] containers) {
        FolderSourceContainerDialog dialog = new FolderSourceContainerDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        FolderSourceContainer container = (FolderSourceContainer)containers[0];
        dialog.setSearchSubfolders(container.isComposite());
        dialog.setInitialSelection(container.getContainer());
        if (dialog.open() == 0) {
            container.dispose();
            Object[] selection = dialog.getResult();
            ArrayList<FolderSourceContainer> list = new ArrayList<FolderSourceContainer>();
            int i = 0;
            while (i < selection.length) {
                if (selection[i] instanceof IFolder) {
                    list.add(new FolderSourceContainer((IContainer)((IFolder)selection[i]), dialog.isSearchSubfolders()));
                }
                ++i;
            }
            return list.toArray(new ISourceContainer[list.size()]);
        }
        return new ISourceContainer[0];
    }
}

