/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.wizard;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.DataBindingUtil;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.common.wizards.PropertyDescriptor;
import com.nvidia.common.wizards.WizardContext;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.internal.Activator;
import com.nvidia.cuda.ide.remote.internal.Messages;
import com.nvidia.cuda.ide.remote.internal.wizard.AbstractRemoteDebugSession;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;

public final class RemotePathField {
    private final Button btnBrowseRemoteExe;
    private PropertyDescriptor<IRemoteConnection> connectionProperty;
    private final WizardContext context;
    private final Label label;
    private PropertyDescriptor<String> pathProperty;
    private final Text remoteExecutable;

    public RemotePathField(Composite composite, WizardContext context) {
        this.context = context;
        this.label = new Label(composite, 0);
        this.label.setText(Messages.RemoteDebug_firstWizardPage_remoteExeLabel);
        this.remoteExecutable = new Text(composite, 2048);
        GridData gd_remoteExecutable = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_remoteExecutable.widthHint = 50;
        this.remoteExecutable.setLayoutData((Object)gd_remoteExecutable);
        this.btnBrowseRemoteExe = new Button(composite, 0);
        this.btnBrowseRemoteExe.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnBrowseRemoteExe.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemotePathField.this.browseForExecutable();
            }
        });
        this.btnBrowseRemoteExe.setText(Messages.RemoteDebug_buttonBrowse);
    }

    public void bind(DataBindingContext dataBindingContext, PropertyDescriptor<IRemoteConnection> connectionProperty, PropertyDescriptor<String> pathProperty) {
        this.connectionProperty = connectionProperty;
        this.pathProperty = pathProperty;
        dataBindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.remoteExecutable, (int)24), this.context.observeProperty(AbstractRemoteDebugSession.PROPERTY_REMOTE_EXECUTABLE));
        IObservableValue connection = this.context.observeProperty(connectionProperty);
        DataBindingUtil.bindEnablement((DataBindingContext)dataBindingContext, (IObservableValue)connection, (Control[])new Control[]{this.remoteExecutable, this.btnBrowseRemoteExe});
    }

    protected void browseForExecutable() {
        String executablePath = (String)this.context.getProperty(this.pathProperty);
        final IRemoteConnection connection = (IRemoteConnection)this.context.getProperty(this.connectionProperty);
        try {
            if (connection != null) {
                this.context.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            connection.connect(IRemoteConnection.Service.Files, monitor);
                        }
                        catch (CoreException e) {
                            if (e != null && e.getCause() instanceof OperationCanceledException) {
                                Activator.log((Exception)((Object)e));
                            }
                            StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]), 2);
                        }
                    }
                });
                String path = connection.browse(this.context.getShell(), Messages.RemoteDebug_firstWizardPage_exeBrowseDialogTitle, executablePath);
                if (path != null) {
                    this.context.setProperty(this.pathProperty, (Object)path);
                }
            }
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
        }
        catch (InterruptedException e) {
            Activator.log(e);
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
    }

    public void setVisible(boolean visible) {
        SWTUtil.setVisible((Control)this.label, (boolean)visible);
        SWTUtil.setVisible((Control)this.remoteExecutable, (boolean)visible);
        SWTUtil.setVisible((Control)this.btnBrowseRemoteExe, (boolean)visible);
        this.label.getParent().layout(true);
    }

    public IStatus validate(boolean shouldExist) {
        IRemoteConnection connection = (IRemoteConnection)this.context.getProperty(this.connectionProperty);
        String remotePath = (String)this.context.getProperty(AbstractRemoteDebugSession.PROPERTY_REMOTE_EXECUTABLE);
        if (CoreUtil.isNullOrEmpty((String)remotePath)) {
            return CoreUtil.errorStatus((String)Messages.RemoteDebug_firstWizardPage_error_noRemoteExeName, (Object[])new Object[0]);
        }
        if (connection != null && connection.isConnected(IRemoteConnection.Service.Files)) {
            if (connection.isFile(remotePath, false, null)) {
                if (!shouldExist) {
                    return CoreUtil.warningStatus((String)Messages.RemoteDebug_firstWizardPage_warning_fileOverwritten, (Object[])new Object[]{remotePath});
                }
            } else if (shouldExist) {
                return CoreUtil.errorStatus((String)Messages.RemoteDebug_firstWizardPage_error_noRemoteFile, (Object[])new Object[]{remotePath});
            }
        }
        return CoreUtil.OK_STATUS;
    }
}

