/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.ior.iiop;

import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.iiop.IIOPProfile;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orb.ORBVersion;
import com.sun.corba.se.spi.orb.ORBVersionFactory;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class GIOPVersion {
    public static final GIOPVersion V1_0 = new GIOPVersion(1, 0);
    public static final GIOPVersion V1_1 = new GIOPVersion(1, 1);
    public static final GIOPVersion V1_2 = new GIOPVersion(1, 2);
    public static final GIOPVersion V1_3 = new GIOPVersion(1, 3);
    public static final GIOPVersion V13_XX = new GIOPVersion(13, 1);
    public static final GIOPVersion DEFAULT_VERSION = V1_2;
    public static final int VERSION_1_0 = 256;
    public static final int VERSION_1_1 = 257;
    public static final int VERSION_1_2 = 258;
    public static final int VERSION_1_3 = 259;
    public static final int VERSION_13_XX = 3329;
    private byte major = 0;
    private byte minor = 0;

    public GIOPVersion() {
    }

    public GIOPVersion(byte by, byte by2) {
        this.major = by;
        this.minor = by2;
    }

    public GIOPVersion(int n, int n2) {
        this.major = (byte)n;
        this.minor = (byte)n2;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public boolean equals(GIOPVersion gIOPVersion) {
        return gIOPVersion.major == this.major && gIOPVersion.minor == this.minor;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof GIOPVersion) {
            return this.equals((GIOPVersion)object);
        }
        return false;
    }

    public int hashCode() {
        return 37 * this.major + this.minor;
    }

    public boolean lessThan(GIOPVersion gIOPVersion) {
        if (this.major < gIOPVersion.major) {
            return true;
        }
        return this.major == gIOPVersion.major && this.minor < gIOPVersion.minor;
    }

    public int intValue() {
        return this.major << 8 | this.minor;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    public static GIOPVersion getInstance(byte by, byte by2) {
        switch (by << 8 | by2) {
            case 256: {
                return V1_0;
            }
            case 257: {
                return V1_1;
            }
            case 258: {
                return V1_2;
            }
            case 259: {
                return V1_3;
            }
            case 3329: {
                return V13_XX;
            }
        }
        return new GIOPVersion(by, by2);
    }

    public static GIOPVersion parseVersion(String string) {
        int n = string.indexOf(46);
        if (n < 1 || n == string.length() - 1) {
            throw new NumberFormatException("GIOP major, minor, and decimal point required: " + string);
        }
        int n2 = Integer.parseInt(string.substring(0, n));
        int n3 = Integer.parseInt(string.substring(n + 1, string.length()));
        return GIOPVersion.getInstance((byte)n2, (byte)n3);
    }

    public static GIOPVersion chooseRequestVersion(ORB oRB, IOR iOR) {
        GIOPVersion gIOPVersion = oRB.getORBData().getGIOPVersion();
        IIOPProfile iIOPProfile = iOR.getProfile();
        GIOPVersion gIOPVersion2 = iIOPProfile.getGIOPVersion();
        ORBVersion oRBVersion = iIOPProfile.getORBVersion();
        if (!oRBVersion.equals(ORBVersionFactory.getFOREIGN()) && oRBVersion.lessThan(ORBVersionFactory.getNEWER())) {
            return V1_0;
        }
        byte by = gIOPVersion2.getMajor();
        byte by2 = gIOPVersion2.getMinor();
        byte by3 = gIOPVersion.getMajor();
        byte by4 = gIOPVersion.getMinor();
        if (by3 < by) {
            return gIOPVersion;
        }
        if (by3 > by) {
            return gIOPVersion2;
        }
        if (by4 <= by2) {
            return gIOPVersion;
        }
        return gIOPVersion2;
    }

    public boolean supportsIORIIOPProfileComponents() {
        return this.getMinor() > 0 || this.getMajor() > 1;
    }

    public void read(InputStream inputStream) {
        this.major = inputStream.read_octet();
        this.minor = inputStream.read_octet();
    }

    public void write(OutputStream outputStream) {
        outputStream.write_octet(this.major);
        outputStream.write_octet(this.minor);
    }
}

