/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.chart;

import com.nvidia.viper.chart.BirtChartFactory;
import com.nvidia.viper.chart.IColorDefinitionsManager;
import com.nvidia.viper.chart.ui.IViperChart;
import com.nvidia.viper.chart.ui.ViperChartSeries;
import java.util.ArrayList;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;

public class BirtChartReportFactory
extends BirtChartFactory {
    protected static int instNum = 0;
    protected String[] dataRowNames;
    protected String labelRowName = "label" + instNum;
    protected ComputedColumn computedLabelColumn;
    protected ComputedColumn[] computedDataColumn;
    protected static BirtChartReportFactory instance;

    protected BirtChartReportFactory() {
    }

    protected static synchronized BirtChartReportFactory instance() {
        if (instance == null) {
            instance = new BirtChartReportFactory();
        }
        return instance;
    }

    public static BirtChartComponents createBirtReportChart(IViperChart chart, IColorDefinitionsManager manager, ElementFactory elementFactory) throws SemanticException {
        BirtChartReportFactory birtChartReportFactoryInstance = BirtChartReportFactory.instance();
        return birtChartReportFactoryInstance.createBirtReportChartHelper(chart, manager, elementFactory);
    }

    protected DataSourceHandle createDataSources(ElementFactory elementFactory) throws SemanticException {
        ScriptDataSourceHandle dataSourceHandle = elementFactory.newScriptDataSource("DataSource" + instNum);
        return dataSourceHandle;
    }

    protected DataSetHandle createDataSets(IViperChart chart, ElementFactory elementFactory) throws SemanticException {
        int j;
        ScriptDataSetHandle dataSetHandle = elementFactory.newScriptDataSet("Data Set");
        dataSetHandle.setDataSource("DataSource" + instNum);
        ViperChartSeries[] chartSeries = chart.getSeries();
        String[] labels = chart.getLabels();
        if (chartSeries.length == 0 || labels.length == 0) {
            throw new RuntimeException("There is no data to plot!");
        }
        boolean sameNumOfDataPoints = true;
        ViperChartSeries[] viperChartSeriesArray = chartSeries;
        int n = chartSeries.length;
        int n2 = 0;
        while (n2 < n) {
            ViperChartSeries series = viperChartSeriesArray[n2];
            if (series.getValues().length != labels.length) {
                sameNumOfDataPoints = false;
                break;
            }
            ++n2;
        }
        if (!sameNumOfDataPoints) {
            throw new RuntimeException("Number of labels and data points not the same!");
        }
        StringBuilder openScriptSB = new StringBuilder();
        openScriptSB.append("i=0;");
        openScriptSB.append("sd = new Array(").append(labels.length).append(");");
        openScriptSB.append("for(j=0; j<").append(labels.length).append("; j++)");
        openScriptSB.append("{ sd[j] = new Array (").append(chartSeries.length + 1).append(");}");
        int i = 0;
        while (i < labels.length) {
            openScriptSB.append("sd[").append(i).append("][0]=").append(labels[i]).append(";");
            j = 0;
            while (j < chartSeries.length) {
                openScriptSB.append("sd[").append(i).append("][").append(j + 1).append("]=");
                openScriptSB.append(chartSeries[j].getValues()[i]).append(";");
                ++j;
            }
            ++i;
        }
        dataSetHandle.setOpen(openScriptSB.toString());
        System.out.println(openScriptSB);
        StringBuilder fetchScriptSB = new StringBuilder();
        fetchScriptSB.append("if (i < ").append(labels.length).append(") {");
        fetchScriptSB.append("row[\"").append(this.labelRowName).append("\"] = sd[i][0];");
        j = 0;
        while (j < this.dataRowNames.length) {
            fetchScriptSB.append("row[\"").append(this.dataRowNames[j]).append("\"] = sd[i][").append(j + 1).append("];");
            ++j;
        }
        fetchScriptSB.append("i++;");
        fetchScriptSB.append("return true;} else return false;");
        dataSetHandle.setFetch(fetchScriptSB.toString());
        System.out.println(fetchScriptSB);
        PropertyHandle computedSet = dataSetHandle.getPropertyHandle("computedColumns");
        computedSet.addItem((IStructure)this.computedLabelColumn);
        ComputedColumn[] computedColumnArray = this.computedDataColumn;
        int n3 = this.computedDataColumn.length;
        int n4 = 0;
        while (n4 < n3) {
            ComputedColumn column = computedColumnArray[n4];
            computedSet.addItem((IStructure)column);
            ++n4;
        }
        return dataSetHandle;
    }

    protected BirtChartComponents createBirtReportChartHelper(IViperChart chart, IColorDefinitionsManager manager, ElementFactory elementFactory) throws SemanticException {
        ExtendedItemHandle eih = elementFactory.newExtendedItem("Chart", "Chart");
        ++instNum;
        int numNonLabelRows = chart.getSeries().length;
        if (numNonLabelRows == 0) {
            throw new RuntimeException("No data points to plot!");
        }
        this.constructRowNamesArray(numNonLabelRows);
        this.constructComputedColumnsArray(numNonLabelRows);
        DataSourceHandle dataSource = this.createDataSources(elementFactory);
        DataSetHandle dataSet = this.createDataSets(chart, elementFactory);
        try {
            eih.setProperty("outputFormat", (Object)"SVG");
            eih.setProperty("dataSet", (Object)"Data Set");
            PropertyHandle computedSet = eih.getColumnBindings();
            this.computedLabelColumn.setExpression("dataSetRow[\"" + this.labelRowName + "\"]");
            computedSet.addItem((IStructure)this.computedLabelColumn);
            int i = 0;
            while (i < numNonLabelRows) {
                this.computedDataColumn[i].setExpression("dataSetRow[\"" + this.dataRowNames[i] + "\"]");
                computedSet.addItem((IStructure)this.computedDataColumn[i]);
                ++i;
            }
        }
        catch (SemanticException e) {
            e.printStackTrace();
        }
        Chart toReturnChart = super.createBirtChartHelper(chart, manager);
        toReturnChart.getBlock().setBounds(BoundsImpl.create((double)0.0, (double)0.0, (double)chart.getWidth(), (double)chart.getHeight()));
        try {
            eih.getReportItem().setProperty("chart.instance", (Object)toReturnChart);
        }
        catch (ExtendedElementException e) {
            e.printStackTrace();
        }
        return new BirtChartComponents(eih, dataSource, dataSet);
    }

    protected void constructComputedColumnsArray(int numNonLabelRows) {
        this.computedDataColumn = new ComputedColumn[numNonLabelRows];
        this.computedLabelColumn = StructureFactory.createComputedColumn();
        this.computedLabelColumn.setName(this.labelRowName);
        this.computedLabelColumn.setExpression("row[\"" + this.labelRowName + "\"]");
        this.computedLabelColumn.setDataType("string");
        int i = 0;
        while (i < this.computedDataColumn.length) {
            this.computedDataColumn[i] = StructureFactory.createComputedColumn();
            this.computedDataColumn[i].setName(this.dataRowNames[i]);
            this.computedDataColumn[i].setExpression("row[\"" + this.dataRowNames[i] + "\"]");
            this.computedDataColumn[i].setDataType("float");
            ++i;
        }
    }

    protected void constructRowNamesArray(int numNonLabelRows) {
        this.dataRowNames = new String[numNonLabelRows];
        int i = 0;
        while (i < numNonLabelRows) {
            this.dataRowNames[i] = "data_" + i + "_" + instNum;
            ++i;
        }
    }

    protected Series createSeries(ViperChartSeries series, IColorDefinitionsManager colorManager, int index) {
        Series toReturnSeries = super.createSeries(series, colorManager);
        toReturnSeries.setDataSet(null);
        ArrayList<Query> queryLis = new ArrayList<Query>();
        Query query = QueryImpl.create((String)("row[\"" + this.dataRowNames[index] + "\"]"));
        queryLis.add(query);
        toReturnSeries.getDataDefinition().addAll(queryLis);
        return toReturnSeries;
    }

    @Override
    protected SeriesDefinition createSeriesDefinition(IViperChart chart, IColorDefinitionsManager colorManager) {
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        sdY.getSeriesPalette().shift(4);
        int i = 0;
        while (i < chart.getSeries().length) {
            ViperChartSeries series = chart.getSeries()[i];
            Series ls1 = this.createSeries(series, colorManager, i);
            sdY.getSeries().add((Object)ls1);
            ++i;
        }
        return sdY;
    }

    @Override
    protected Series createLabelSeriesWithData(DataSet ds) {
        Series series = SeriesImpl.create();
        Query query = QueryImpl.create((String)("row[\"" + this.labelRowName + "\"]"));
        series.getDataDefinition().add((Object)query);
        return series;
    }

    protected static /* bridge */ /* synthetic */ BirtChartFactory instance() {
        return BirtChartReportFactory.instance();
    }

    public static class BirtChartComponents {
        public final ExtendedItemHandle chart;
        public final DataSourceHandle dataSource;
        public final DataSetHandle dataSet;

        protected BirtChartComponents(ExtendedItemHandle chart, DataSourceHandle dataSource, DataSetHandle dataSet) {
            this.chart = chart;
            this.dataSource = dataSource;
            this.dataSet = dataSet;
        }
    }
}

